% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelines.R
\name{mlr_graphs_probregrcompositor}
\alias{mlr_graphs_probregrcompositor}
\alias{pipeline_probregrcompositor}
\title{Estimate Regression distr Predict Type Pipeline}
\usage{
pipeline_probregrcompositor(
  learner,
  learner_se = NULL,
  dist = "Normal",
  graph_learner = FALSE
)
}
\arguments{
\item{learner}{\verb{[mlr3::Learner]|[mlr3pipelines::PipeOp]|[mlr3pipelines::Graph]} \cr
Either a \code{Learner} which will be wrapped in \link[mlr3pipelines:PipeOpLearner]{mlr3pipelines::PipeOpLearner}, a \code{PipeOp} which will
be wrapped in \link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or a \code{Graph} itself. Underlying \code{Learner} should be
\link[mlr3:LearnerRegr]{LearnerRegr}.}

\item{learner_se}{\verb{[mlr3::Learner]|[mlr3pipelines::PipeOp]} \cr
Optional \link[mlr3:LearnerRegr]{LearnerRegr} with predict_type \code{se} to estimate the standard
error. If left \code{NULL} then \code{learner} must have \code{se} in predict_types.}

\item{dist}{\code{character(1)}\cr
Location-scale distribution to use for composition.
Current possibilities are' \verb{"Cauchy", "Gumbel", "Laplace", "Logistic", "Normal} (default).}

\item{graph_learner}{\code{logical(1)}\cr
If \code{TRUE} returns wraps the \link[mlr3pipelines:Graph]{Graph} as a
\link[mlr3pipelines:GraphLearner]{GraphLearner} otherwise (default) returns as a \code{Graph}.}
}
\value{
\link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or \link[mlr3pipelines:GraphLearner]{mlr3pipelines::GraphLearner}
}
\description{
Wrapper around \link{PipeOpProbregrCompositor} to simplify \link[mlr3pipelines:Graph]{Graph} creation.
}
\examples{
\dontrun{
if (requireNamespace("mlr3pipelines", quietly = TRUE) &&
  requireNamespace("rpart", quietly = TRUE)) {
library("mlr3")
library("mlr3pipelines")

task = tsk("boston_housing")

# method 1 - one learner for response and se
pipe = ppl(
  "probregrcompositor",
  learner = lrn("regr.featureless", predict_type = "se"),
  dist = "Normal"
)
pipe$train(task)
pipe$predict(task)

# method 2 - one learner for response and one for se
pipe = ppl(
  "probregrcompositor",
  learner = lrn("regr.rpart"),
  learner_se = lrn("regr.featureless", predict_type = "se"),
  dist = "Logistic"
)
pipe$train(task)
pipe$predict(task)
}
}
}
\seealso{
Other pipelines: 
\code{\link{mlr_graphs_crankcompositor}},
\code{\link{mlr_graphs_distrcompositor}},
\code{\link{mlr_graphs_survaverager}},
\code{\link{mlr_graphs_survbagging}},
\code{\link{mlr_graphs_survtoregr}}
}
\concept{pipelines}
