% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_greplicate.R
\name{pipeline_greplicate}
\alias{pipeline_greplicate}
\title{Create Disjoint Graph Union of Copies of a Graph}
\usage{
pipeline_greplicate(graph, n)
}
\arguments{
\item{graph}{\code{\link{Graph}} \cr
Graph to replicate.}

\item{n}{\code{integer(1)}
Number of copies to create.}
}
\value{
\code{\link{Graph}} containing \code{n} copies of input \code{graph}.
}
\description{
Create a new \code{\link{Graph}} containing \code{n} copies of the input \code{\link{Graph}} / \code{\link{PipeOp}}. To avoid ID
collisions, PipeOp IDs are suffixed with \verb{_i} where \code{i} ranges from 1 to \code{n}.

All input arguments are cloned and have no references in common with the returned \code{\link{Graph}}.
}
\examples{
library("mlr3")

po_pca = po("pca")
pipeline_greplicate(po_pca, n = 2)
}
\seealso{
Other Graph operators: 
\code{\link{\%>>\%}()},
\code{\link{as_graph}()},
\code{\link{as_pipeop}()},
\code{\link{assert_graph}()},
\code{\link{assert_pipeop}()},
\code{\link{chain_graphs}()},
\code{\link{greplicate}()},
\code{\link{gunion}()}
}
\concept{Graph operators}
