% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_graphs.R
\docType{data}
\name{mlr_graphs}
\alias{mlr_graphs}
\title{Dictionary of (sub-)graphs}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link[mlr3misc:Dictionary]{mlr3misc::Dictionary}}.
}
\description{
A simple \code{\link[mlr3misc:Dictionary]{Dictionary}} storing objects of class \code{\link{Graph}}.
The dictionary contains a collection of often-used graph structures, and it's aim
is solely to make often-used functions more accessible.
Each \code{Graph} has an associated help page, which can be accessed via \verb{?mlr_graphs_<key>}, i.e.
\code{?mlr_graphs_bagging}.
}
\section{Methods}{

Methods inherited from \code{\link[mlr3misc:Dictionary]{Dictionary}}, as well as:
\itemize{
\item \code{add(key, value)}\cr
(\code{character(1)}, \code{function})\cr
Adds constructor \code{value} to the dictionary with key \code{key}, potentially
overwriting a previously stored item.
}
}

\section{S3 methods}{

\itemize{
\item \code{as.data.table(dict)}\cr
\code{\link[mlr3misc:Dictionary]{Dictionary}} -> \code{\link[data.table:data.table]{data.table::data.table}}\cr
Returns a \code{data.table} with column \code{key} (\code{character}).
}
}

\examples{
\dontshow{if (requireNamespace("rpart")) withAutoprint(\{ # examplesIf}
library(mlr3)
lrn = lrn("regr.rpart")
task = mlr_tasks$get("boston_housing")

# Robustify the learner for the task.
gr = pipeline_robustify(task, lrn) \%>>\% po("learner", lrn)
# or equivalently
gr = mlr_graphs$get("robustify", task = task, learner = lrn) \%>>\% po(lrn)
# or equivalently
gr = ppl("robustify", task, lrn) \%>>\% po("learner", lrn)

# all Graphs currently in the dictionary:
as.data.table(mlr_graphs)
\dontshow{\}) # examplesIf}
}
\seealso{
Other mlr3pipelines backend related: 
\code{\link{Graph}},
\code{\link{PipeOp}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_updatetarget}}

Other Dictionaries: 
\code{\link{mlr_pipeops}}
}
\concept{Dictionaries}
\concept{mlr3pipelines backend related}
\keyword{datasets}
