format_bib = function(...) {
  str = vapply(list(...), function(entry) tools::toRd(bibentries[[entry]]), FUN.VALUE = "")
  paste0(str, collapse = "\n\n")
}

#' @importFrom utils bibentry
bibentries = c( # nolint start
  brodersen_2010     = bibentry("inproceedings",
    title            = "The Balanced Accuracy and Its Posterior Distribution",
    author           = "Kay Henning Brodersen and Cheng Soon Ong and Klaas Enno Stephan and Joachim M. Buhmann",
    year             = "2010",
    booktitle        = "2010 20th International Conference on Pattern Recognition",
    publisher        = "IEEE",
    doi              = "10.1109/icpr.2010.764"
  ),
  davis_2006         = bibentry("inproceedings",
    title            = "The relationship between precision-recall and ROC curves",
    author           = "Jesse Davis and Mark Goadrich",
    year             = "2006",
    booktitle        = "Proceedings of the 23rd International Conference on Machine Learning",
    publisher        = "ACM",
    isbn             = "9781595933836"
  ),
  de_myttenaere_2016 = bibentry("article",
    title            = "Mean Absolute Percentage Error for regression models",
    author           = "de Myttenaere, Arnaud and Golden, Boris and Le Grand, B\u00e9n\u00e9dicte and Rossi, Fabrice",
    year             = "2016",
    journal          = "Neurocomputing",
    publisher        = "Elsevier BV",
    volume           = "192",
    pages            = "38-48",
    doi              = "10.1016/j.neucom.2015.12.114",
    issn             = "0925-2312"
  ),
  guyon_2015         = bibentry("inproceedings",
    title            = "Design of the 2015 {ChaLearn} {AutoML} challenge",
    author           = "Isabelle Guyon and Kristin Bennett and Gavin Cawley and Hugo Jair Escalante and Sergio Escalera and  Tin Kam Ho and Nuria Macia and Bisakha Ray and Mehreen Saeed and Alexander Statnikov and Evelyne Viegas",
    year             = "2015",
    booktitle        = "2015 International Joint Conference on Neural Networks ({IJCNN})",
    publisher        = "IEEE",
    doi              = "10.1109/ijcnn.2015.7280767"
  ),
  matthews_1975      = bibentry("article",
    title            = "Comparison of the predicted and observed secondary structure of T4 phage lysozyme",
    author           = "Brian W. Matthews",
    year             = "1975",
    journal          = "Biochimica et Biophysica Acta ({BBA}) - Protein Structure",
    publisher        = "Elsevier {BV}",
    volume           = "405",
    number           = "2",
    pages            = "442--451",
    doi              = "10.1016/0005-2795(75)90109-9"
  ),
  rijsbergen_1979    = bibentry("book",
    title            = "Information Retrieval",
    author           = "Rijsbergen, C. J. Van",
    year             = "1979",
    publisher        = "Butterworth-Heinemann",
    address          = "Newton, MA, USA",
    isbn             = "408709294",
    edition          = "2nd"
  ),
  rosset_2006        = bibentry("article",
    title            = "Ranking-based evaluation of regression models",
    author           = "Saharon Rosset and Claudia Perlich and Bianca Zadrozny",
    year             = "2006",
    journal          = "Knowledge and Information Systems",
    publisher        = "Springer Science and Business Media {LLC}",
    volume           = "12",
    number           = "3",
    pages            = "331--353",
    doi              = "10.1007/s10115-006-0037-3"
  ),
  goutte_2005        = bibentry("inproceedings",
    doi              = "10.1007/978-3-540-31865-1_25",
    year             = "2005",
    publisher        = "Springer Berlin Heidelberg",
    pages            = "345--359",
    author           = "Cyril Goutte and Eric Gaussier",
    title            = "A Probabilistic Interpretation of Precision,  Recall and F-Score,  with Implication for Evaluation",
    booktitle        = "Lecture Notes in Computer Science"
  ),
  youden_1950        = bibentry("article",
    title            = "Index for rating diagnostic tests",
    author           = "W. J. Youden",
    year             = "1950",
    journal          = "Cancer",
    publisher        = "Wiley",
    volume           = "3",
    number           = "1",
    pages            = "32--35",
    doi              = "10.1002/1097-0142(1950)3:1<32::aid-cncr2820030106>3.0.co;2-3"
  ),
  brier_1950         = bibentry("article",
    doi              = "10.1175/1520-0493(1950)078<0001:vofeit>2.0.co;2",
    year             = "1950",
    month            = "jan",
    publisher        = "American Meteorological Society",
    volume           = "78",
    number           = "1",
    pages            = "1--3",
    author           = "Glenn W. Brier",
    title            = "Verification of forecasts expressed in terms of probability",
    journal          = "Monthly Weather Review"
  ),
  ferri_2009         = bibentry("article",
    doi              = "10.1016/j.patrec.2008.08.010",
    year             = "2009",
    month            = "jan",
    publisher        = "Elsevier",
    volume           = "30",
    number           = "1",
    pages            = "27--38",
    author           = "Ferri, C\u00e9sar and Hern\u00e1ndez-Orallo, Jos\u00e9 and Modroiu, R",
    title            = "An experimental comparison of performance measures for classification",
    journal          = "Pattern Recognition Letters"
  ),
  hand_2001          = bibentry("article",
    title            = "A simple generalisation of the area under the ROC curve for multiple class classification problems",
    author           = "Hand, David J and Till, Robert J",
    journal          = "Machine learning",
    volume           = "45",
    number           = "2",
    pages            = "171--186",
    year             = "2001",
    publisher        = "Springer"
  ),
  fawcett_2001       = bibentry("inproceedings",
    title            = "Using rule sets to maximize ROC performance",
    author           = "Fawcett, Tom",
    booktitle        = "Proceedings 2001 IEEE international conference on data mining",
    pages            = "131--138",
    year             = "2001",
    organization     = "IEEE"
  ),
  jaccard_1901       = bibentry("article",
    doi              = "10.5169/SEALS-266450",
    author           = "Jaccard,  Paul",
    title            = "\u00c9tude comparative de la distribution florale dans une portion des Alpes et du Jura",
    journal          = "Bulletin de la Soci\u00e9t\u00e9 Vaudoise des Sciences Naturelles",
    volume           = "37",
    pages            = "547-579",
    publisher        = "Imprimerie Corbaz & Comp.",
    year             = "1901"
  ),
  bommert_2017       = bibentry("article",
    doi              = "10.1155/2017/7907163",
    year             = "2017",
    publisher        = "Hindawi Limited",
    volume           = "2017",
    pages            = "1--18",
    author           = "Andrea Bommert and J\u00f6rg Rahnenf\u00fchrer and Michel Lang",
    title            = "A Multicriteria Approach to Find Predictive and Sparse Models with Stable Feature Selection for High-Dimensional Data",
    journal          = "Computational and Mathematical Methods in Medicine"
  ),
  nogueira_2016      = bibentry("incollection",
    doi              = "10.1007/978-3-319-46227-1_28",
    year             = "2016",
    publisher        = "Springer International Publishing",
    pages            = "442--457",
    author           = "Sarah Nogueira and Gavin Brown",
    title            = "Measuring the Stability of Feature Selection",
    booktitle        = "Machine Learning and Knowledge Discovery in Databases"
  ),
  stabm              = bibentry("article",
    title            = "{stabm}: Stability Measures for Feature Selection",
    author           = "Andrea Bommert and Michel Lang",
    journal          = "Journal of Open Source Software",
    year             = "2021",
    doi              = "10.21105/joss.03010",
    publisher        = "The Open Journal",
    volume           = "6",
    number           = "59",
    pages            = "3010"
  )

) # nolint end
