% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcqFunctionEHVI.R
\name{mlr_acqfunctions_ehvi}
\alias{mlr_acqfunctions_ehvi}
\alias{AcqFunctionEHVI}
\title{Acquisition Function Expected Hypervolume Improvement}
\description{
Exact Expected Hypervolume Improvement.
Calculates the exact expected hypervolume improvement in the case of two objectives.
In the case of optimizing more than two objective functions, \link{AcqFunctionEHVIGH} can be used.
See Emmerich et al. (2016) for details.
}
\examples{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud")) {
  library(bbotk)
  library(paradox)
  library(mlr3learners)
  library(data.table)

  fun = function(xs) {
    list(y1 = xs$x^2, y2 = (xs$x - 2) ^ 2)
  }
  domain = ps(x = p_dbl(lower = -10, upper = 10))
  codomain = ps(y1 = p_dbl(tags = "minimize"), y2 = p_dbl(tags = "minimize"))
  objective = ObjectiveRFun$new(fun = fun, domain = domain, codomain = codomain)

  instance = OptimInstanceBatchMultiCrit$new(
    objective = objective,
    terminator = trm("evals", n_evals = 5))

  instance$eval_batch(data.table(x = c(-6, -5, 3, 9)))

  learner = default_gp()

  surrogate = srlrn(list(learner, learner$clone(deep = TRUE)), archive = instance$archive)

  acq_function = acqf("ehvi", surrogate = surrogate)

  acq_function$surrogate$update()
  acq_function$update()
  acq_function$eval_dt(data.table(x = c(-1, 0, 1)))
}
}
\references{
\itemize{
\item Emmerich, Michael, Yang, Kaifeng, Deutz, André, Wang, Hao, Fonseca, M. C (2016).
\dQuote{A Multicriteria Generalization of Bayesian Global Optimization.}
In Pardalos, M. P, Zhigljavsky, Anatoly, Žilinskas, Julius (eds.), \emph{Advances in Stochastic and Deterministic Global Optimization}, 229--242.
Springer International Publishing, Cham.
}
}
\seealso{
Other Acquisition Function: 
\code{\link{AcqFunction}},
\code{\link{mlr_acqfunctions}},
\code{\link{mlr_acqfunctions_aei}},
\code{\link{mlr_acqfunctions_cb}},
\code{\link{mlr_acqfunctions_ehvigh}},
\code{\link{mlr_acqfunctions_ei}},
\code{\link{mlr_acqfunctions_eips}},
\code{\link{mlr_acqfunctions_mean}},
\code{\link{mlr_acqfunctions_multi}},
\code{\link{mlr_acqfunctions_pi}},
\code{\link{mlr_acqfunctions_sd}},
\code{\link{mlr_acqfunctions_smsego}}
}
\concept{Acquisition Function}
\section{Super classes}{
\code{\link[bbotk:Objective]{bbotk::Objective}} -> \code{\link[mlr3mbo:AcqFunction]{mlr3mbo::AcqFunction}} -> \code{AcqFunctionEHVI}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ys_front}}{(\code{matrix()})\cr
Approximated Pareto front. Sorted by the first objective.
Signs are corrected with respect to assuming minimization of objectives.}

\item{\code{ref_point}}{(\code{numeric()})\cr
Reference point.
Signs are corrected with respect to assuming minimization of objectives.}

\item{\code{ys_front_augmented}}{(\code{matrix()})\cr
Augmented approximated Pareto front. Sorted by the first objective.
Signs are corrected with respect to assuming minimization of objectives.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AcqFunctionEHVI-new}{\code{AcqFunctionEHVI$new()}}
\item \href{#method-AcqFunctionEHVI-update}{\code{AcqFunctionEHVI$update()}}
\item \href{#method-AcqFunctionEHVI-clone}{\code{AcqFunctionEHVI$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval"><a href='../../bbotk/html/Objective.html#method-Objective-eval'><code>bbotk::Objective$eval()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="format"><a href='../../bbotk/html/Objective.html#method-Objective-format'><code>bbotk::Objective$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="help"><a href='../../bbotk/html/Objective.html#method-Objective-help'><code>bbotk::Objective$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="print"><a href='../../bbotk/html/Objective.html#method-Objective-print'><code>bbotk::Objective$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_dt"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_dt'><code>mlr3mbo::AcqFunction$eval_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_many"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_many'><code>mlr3mbo::AcqFunction$eval_many()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionEHVI-new"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionEHVI-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionEHVI$new(surrogate = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{surrogate}}{(\code{NULL} | \link{SurrogateLearnerCollection}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionEHVI-update"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionEHVI-update}{}}}
\subsection{Method \code{update()}}{
Update the acquisition function and set \code{ys_front} and \code{ref_point}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionEHVI$update()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionEHVI-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionEHVI-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionEHVI$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
