% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{report_fairness}
\alias{report_fairness}
\title{Create a Fairness Report}
\usage{
report_fairness(
  filename = "fairness_report.Rmd",
  objects,
  edit = FALSE,
  check_objects = FALSE,
  build = FALSE
)
}
\arguments{
\item{filename}{(\code{character(1)})\cr
File path or name for new file that should be created.}

\item{objects}{(\code{list()})\cr
A named list of objects required for the fairness report.
Objects are saved as \verb{<name>.rds} in the new folder created for the report.
\itemize{
\item \code{task} :: The \code{\link{Task}} a report should be created for.
\item \code{resample_result} ::  A \link[mlr3:ResampleResult]{mlr3::ResampleResult} result to be analyzed.
\item \code{...} :: any other objects passed on for the report.
}}

\item{edit}{(\code{logical(1)})\cr
\code{TRUE} to edit the template immediately.}

\item{check_objects}{(\code{logical(1)})\cr
Should items in \code{objects} be checked? If \code{FALSE}, no checks on \code{object} are performed.}

\item{build}{(\code{logical(1)})\cr
Should the report be built after creation? Initialized to \code{FALSE}.}
}
\value{
Invisibly returns the path to the newly created file(s).
}
\description{
Creates a new \CRANpkg{rmarkdown} template with a skeleton of  reported metrics and visualizations.
Uses the awesome markdown template created by Chris Garbin
\href{https://github.com/fau-masters-collected-works-cgarbin/model-card-template}{from Github}.
}
\examples{
  report_file = tempfile()
  task = tsk("compas")
  learner = lrn("classif.rpart", predict_type = "prob")
  rr = resample(task, learner, rsmp("cv", folds = 3L))
  report_fairness(report_file, list(task = task, resample_result = rr))
}
\seealso{
Other fairness_reports: 
\code{\link{report_datasheet}()},
\code{\link{report_modelcard}()}
}
\concept{fairness_reports}
