% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_task_clust.R
\name{as_task_clust}
\alias{as_task_clust}
\alias{as_task_clust.TaskClust}
\alias{as_task_clust.data.frame}
\alias{as_task_clust.DataBackend}
\title{Convert to a Cluster Task}
\usage{
as_task_clust(x, ...)

\method{as_task_clust}{TaskClust}(x, clone = FALSE, ...)

\method{as_task_clust}{data.frame}(x, id = deparse(substitute(x)), ...)

\method{as_task_clust}{DataBackend}(x, id = deparse(substitute(x)), ...)
}
\arguments{
\item{x}{(\code{any})\cr
Object to convert.}

\item{...}{(\code{any})\cr
Additional arguments.}

\item{clone}{(\code{logical(1)})\cr
If \code{TRUE}, ensures that the returned object is not the same as the input \code{x}.}

\item{id}{(\code{character(1)})\cr
Id for the new task.
Defaults to the (deparsed and substituted) name of \code{x}.}
}
\value{
\link{TaskClust}.
}
\description{
Convert object to a \link{TaskClust}.
This is a S3 generic, specialized for at least the following objects:
\enumerate{
\item \link{TaskClust}: ensure the identity.
\item \code{\link[=data.frame]{data.frame()}} and \link{DataBackend}: provides an alternative to calling constructor of \link{TaskClust}.
}
}
\examples{
as_task_clust(datasets::USArrests)
}
