% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_roc_measures.R
\name{score_roc_measures}
\alias{score_roc_measures}
\title{Calculate ROC Measures}
\usage{
score_roc_measures(pred)
}
\arguments{
\item{pred}{(\link{PredictionClassif})\cr
The prediction object.}
}
\value{
\code{list()}\cr
A list containing two elements \code{confusion_matrix} which is the 2 times 2 confusion matrix of absolute frequencies and \code{measures}, a list of the above mentioned measures.
}
\description{
Calculate a set of roc performance measures based on the confusion matrix.
\itemize{
\item \code{tpr} True positive rate (Sensitivity, Recall)
\item \code{fpr} False positive rate (Fall-out)
\item \code{fnr} False negative rate (Miss rate)
\item \code{tnr} True negative rate (Specificity)
\item \code{ppv} Positive predictive value (Precision)
\item \code{fomr} False omission rate
\item \code{lrp} Positive likelihood ratio (LR+)
\item \code{fdr} False discovery rate
\item \code{npv} Negative predictive value
\item \code{acc} Accuracy
\item \code{lrm} Negative likelihood ratio (LR-)
\item \code{dor} Diagnostic odds ratio
}
}
\examples{
learner = lrn("classif.rpart", predict_type = "prob")
splits = partition(task = tsk("pima"), ratio = 0.7)
task = tsk("pima")
learner$train(task)
pred = learner$predict(task)
score_roc_measures(pred)
}
