% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSimple.R
\name{mlr_measures_regr.rsq}
\alias{mlr_measures_regr.rsq}
\title{R Squared}
\description{
Regression measure defined as \deqn{
  1 - \frac{\sum_{i=1}^n \left( t_i - r_i \right)^2}{\sum_{i=1}^n \left( t_i - \bar{t} \right)^2}.
}{
  1 - sum((t - r)^2) / sum((t - mean(t))^2).
}
Also known as coefficient of determination or explained variation.
Subtracts the \code{\link[mlr3measures:rse]{rse()}} from 1, hence it compares the squared error of
the predictions relative to a naive model predicting the mean.
}
\note{
The score function calls \code{\link[mlr3measures:rsq]{mlr3measures::rsq()}} from package \CRANpkg{mlr3measures}.

If the measure is undefined for the input, \code{NaN} is returned.
This can be customized by setting the field \code{na_value}.
}
\section{Dictionary}{

This \link{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_measures} or with the associated sugar function \code{\link[=msr]{msr()}}:\preformatted{mlr_measures$get("rsq")
msr("rsq")
}
}

\section{Meta Information}{


\itemize{
\item Type: \code{"regr"}
\item Range: \eqn{(-\infty, 1]}{(-Inf, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}

}

\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Measure]{Measures}: \link{mlr_measures}

\code{as.data.table(mlr_measures)} for a complete table of all (also dynamically created) \link{Measure} implementations.

Other regression measures: 
\code{\link{mlr_measures_regr.bias}},
\code{\link{mlr_measures_regr.ktau}},
\code{\link{mlr_measures_regr.mae}},
\code{\link{mlr_measures_regr.mape}},
\code{\link{mlr_measures_regr.maxae}},
\code{\link{mlr_measures_regr.medae}},
\code{\link{mlr_measures_regr.medse}},
\code{\link{mlr_measures_regr.mse}},
\code{\link{mlr_measures_regr.msle}},
\code{\link{mlr_measures_regr.pbias}},
\code{\link{mlr_measures_regr.rae}},
\code{\link{mlr_measures_regr.rmse}},
\code{\link{mlr_measures_regr.rmsle}},
\code{\link{mlr_measures_regr.rrse}},
\code{\link{mlr_measures_regr.rse}},
\code{\link{mlr_measures_regr.sae}},
\code{\link{mlr_measures_regr.smape}},
\code{\link{mlr_measures_regr.srho}},
\code{\link{mlr_measures_regr.sse}}
}
\concept{regression measures}
