% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataBackendMatrix.R
\name{DataBackendMatrix}
\alias{DataBackendMatrix}
\title{DataBackend for Matrix}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{DataBackend}.}
\description{
\link{DataBackend} for \CRANpkg{Matrix}. Data is stored as (sparse) matrix.
}
\section{Construction}{
\preformatted{DataBackendMatrix$new(data, primary_key = NULL)
as_data_backend(data, primary_key = NULL, ...)
}
\itemize{
\item \code{data} :: \code{\link[Matrix:Matrix]{Matrix::Matrix()}}.
\item \code{primary_key} :: \code{character(1)}\cr
Not supported by this backend. Rows are addresses by their \code{\link[=rownames]{rownames()}}.
If the matrix does not have row names, integer row indices are used.
}
}

\section{Fields}{

See \link{DataBackend}.
}

\section{Methods}{

See \link{DataBackend}.
}

\examples{
requireNamespace("Matrix")
data = Matrix::Matrix(sample(0:1, 20, replace = TRUE), ncol = 2)
colnames(data) = c("x1", "x2")
rownames(data) = paste0("row_", 1:10)

b = as_data_backend(data)
b$head()
b$data(b$rownames[1:3], b$colnames, data_format = "Matrix")
}
\seealso{
Other DataBackend: 
\code{\link{DataBackendDataTable}},
\code{\link{DataBackend}},
\code{\link{as_data_backend}()}
}
\concept{DataBackend}
