% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResampleResult.R
\docType{data}
\name{ResampleResult}
\alias{ResampleResult}
\title{Container for Results of \code{resample()}}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
This is the result container object returned by \code{\link[=resample]{resample()}}.

Note that all stored objects are accessed by reference.
Do not modify any object without cloning it first.
}
\section{Construction}{
\preformatted{rr = ResampleResult$new(data, uhash = NULL)
}
\itemize{
\item \code{data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table with data for one resampling iteration per row:
\link{Task}, \link{Learner}, \link{Resampling}, iteration (\code{integer(1)}), and \link{Prediction}.
\item \code{uhash} :: \code{character(1)}\cr
Unique hash for this \code{ResampleResult}. If \code{NULL}, a new unique hash is generated.
This unique hash is primarily needed to group information in \link{BenchmarkResult}s.
}
}

\section{Fields}{

\itemize{
\item \code{data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Internal data storage.
We discourage users to directly work with this field.
\item \code{task} :: \link{Task}\cr

The task \code{\link[=resample]{resample()}} operated on.
\item \code{learners} :: list of \link{Learner}\cr
List of trained learners, sorted by resampling iteration.
\item \code{resampling} :: \link{Resampling}\cr
Instantiated \link{Resampling} object which stores the splits into training and test.
\item \code{warnings} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a table with all warning messages.
Column names are \code{"iteration"} and \code{"msg"}.
Note that there can be multiple rows per resampling iteration if multiple warnings have been recorded.
\item \code{errors} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a table with all error messages.
Column names are \code{"iteration"} and \code{"msg"}.
Note that there can be multiple rows per resampling iteration if multiple errors have been recorded.
\item \code{uhash} :: \code{character(1)}\cr
Unique hash for this object.
}
}

\section{Methods}{

\itemize{
\item \code{predictions(predict_sets = "test")}\cr
\code{character()} -> list of \link{Prediction}\cr
List of prediction objects, sorted by resampling iteration.
If multiple sets are given, these are combined to a single one for each iteration.
\item \code{prediction(predict_sets = "test")}\cr
\code{character()} -> \link{Prediction}\cr
Combined \link{Prediction} of all individual resampling iterations, and all provided predict sets.
Note that performance measures do not operate on this object,
but instead on each prediction object separately and then combine the performance scores
with the aggregate function of the respective \link{Measure}.
\item \code{score(measures = NULL, ids = TRUE)}\cr
(list of \link{Measure}, \code{logical(1)}) -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a table with one row for each resampling iteration, including all involved objects:
\link{Task}, \link{Learner}, \link{Resampling}, iteration number (\code{integer(1)}), and \link{Prediction}.
A column with the individual (per resampling iteration) performance is added for each \link{Measure}, named with the id of the respective measure.
If \code{ids} is \code{TRUE}, extra columns with the ids of objects (\code{"task_id"}, \code{"learner_id"}, \code{"resampling_id"}) are binded to the table to allow a more convenient subsetting.
If \code{measures} is \code{NULL}, \code{measures} defaults to the return value of \code{\link[=default_measures]{default_measures()}}.
\item \code{aggregate(measures = NULL)}\cr
list of \link{Measure} -> named \code{numeric()}\cr
Calculates and aggregates performance values for all provided measures, according to the respective aggregation function in \link{Measure}.
If \code{measures} is \code{NULL}, \code{measures} defaults to the return value of \code{\link[=default_measures]{default_measures()}}.
\item \code{help()}\cr
() -> \code{NULL}\cr
Opens the help page for this object.
}
}

\section{S3 Methods}{

\itemize{
\item \code{as.data.table(rr)}\cr
\link{ResampleResult} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a copy of the internal data.
}
}

\examples{
task = tsk("iris")
learner = lrn("classif.rpart")
resampling = rsmp("cv", folds = 3)
rr = resample(task, learner, resampling)
print(rr)

rr$aggregate(msr("classif.acc"))
rr$prediction()
rr$prediction()$confusion
rr$warnings
rr$errors
}
\keyword{datasets}
