% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreprocWrapperCaret.R
\name{makePreprocWrapperCaret}
\alias{makePreprocWrapperCaret}
\title{Fuse learner with preprocessing}
\usage{
makePreprocWrapperCaret(learner, ...)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{...}{[any]\cr
See \code{\link[caret]{preProcess}} for parameters not listed above.
If you use them you might want to define them in the \code{add.par.set} so that they can be tuned.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Fuses a learner with preprocessing methods provided by \code{\link[caret]{preProcess}}.
 Before training the preprocessing will be performed and the preprocessing model will be stored.
 Before prediction the preprocessing model will transform the test data according to the trained model.

 After being wrapped the learner will support missing values although this will only be the case if \code{ppc.knnImpute}, \code{ppc.bagImpute} or \code{ppc.medianImpute} is set to \code{TRUE}.
}
\seealso{
Other wrapper: \code{\link{makeBaggingWrapper}},
  \code{\link{makeCostSensClassifWrapper}},
  \code{\link{makeCostSensRegrWrapper}},
  \code{\link{makeDownsampleWrapper}},
  \code{\link{makeFeatSelWrapper}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeImputeWrapper}},
  \code{\link{makeMulticlassWrapper}},
  \code{\link{makeMultilabelBinaryRelevanceWrapper}},
  \code{\link{makeOverBaggingWrapper}},
  \code{\link{makePreprocWrapper}},
  \code{\link{makeSMOTEWrapper}},
  \code{\link{makeTuneWrapper}},
  \code{\link{makeUndersampleWrapper}},
  \code{\link{makeWeightedClassesWrapper}}
}

