% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarkTest.R
\name{friedmanTestBMR}
\alias{friedmanTestBMR}
\title{Perform overall Friedman test for a BenchmarkResult.}
\usage{
friedmanTestBMR(bmr, measure = NULL, aggregation = "default")
}
\arguments{
\item{bmr}{[\code{\link{BenchmarkResult}}]\cr
Benchmark result.}

\item{measure}{[\code{\link{Measure}}]\cr
Performance measure.
Default is the default measure for the task, see here \code{\link{getDefaultMeasure}}.}

\item{aggregation}{[\code{character(1)}] \cr
\dQuote{mean} or \dQuote{default}. See \code{\link{getBMRAggrPerformances}}
for details on \dQuote{default}.}
}
\value{
A list of class \code{htest}. \cr
See \code{\link{friedman.test}} for details.\cr
}
\description{
Performs a \code{\link{friedman.test}} for a selected measure. \cr
The null hypothesis is that apart from an effect of the different
[\code{tasks}], the location parameter (aggregated performance-measure)
is the same for each \code{learner}.
}
\examples{
lrns = list(makeLearner("classif.nnet"), makeLearner("classif.rpart"))
tasks = list(iris.task, sonar.task)
rdesc = makeResampleDesc("CV", iters = 2L)
res = benchmark(lrns, tasks, rdesc, acc)
friedmanTestBMR(res)

}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{generateBenchmarkSummaryData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateRankMatrixAsBarData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBenchmarkResult}},
  \code{\link{plotBenchmarkSummary}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotRankMatrixAsBar}}
}

