% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchmark.R
\name{reduceBatchmarkResults}
\alias{reduceBatchmarkResults}
\title{Reduce results of a batch-distributed benchmark.}
\usage{
reduceBatchmarkResults(ids = NULL, keep.pred = TRUE,
  show.info = getMlrOption("show.info"),
  reg = batchtools::getDefaultRegistry())
}
\arguments{
\item{ids}{(\link{data.frame} or \link{integer})\cr
A \link[base:data.frame]{base::data.frame} (or \link[data.table:data.table]{data.table::data.table})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to all successfully terminated jobs (return value of \link[batchtools:findDone]{batchtools::findDone}.}

\item{keep.pred}{(\code{logical(1)})\cr
Keep the prediction data in the \code{pred} slot of the result object.
If you do many experiments (on larger data sets) these objects might unnecessarily increase
object size / mem usage, if you do not really need them.
In this case you can set this argument to \code{FALSE}.
Default is \code{TRUE}.}

\item{show.info}{(\code{logical(1)})\cr
Print verbose output on console?
Default is set via \link{configureMlr}.}

\item{reg}{(\link[batchtools:ExperimentRegistry]{batchtools::ExperimentRegistry})\cr
Registry, created by \link[batchtools:makeExperimentRegistry]{batchtools::makeExperimentRegistry}. If not explicitly passed,
uses the last created registry.}
}
\value{
(\link{BenchmarkResult}).
}
\description{
This creates a \link{BenchmarkResult} from a \link[batchtools:ExperimentRegistry]{batchtools::ExperimentRegistry}.
To setup the benchmark have a look at \link{batchmark}.
}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{batchmark}}, \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearnerShortNames}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}}, \code{\link{getBMRModels}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskDescs}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCritDifferences}}
}
