/**
 * @file src/linear_svm.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R linear_svm binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/linear_svm/linear_svm_main.cpp>

// [[Rcpp::export]]
void linear_svm_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a LinearSVMModel parameter.
// [[Rcpp::export]]
SEXP IO_GetParamLinearSVMModelPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<LinearSVMModel>) IO::GetParam<LinearSVMModel*>(paramName));
}

// Set the pointer to a LinearSVMModel parameter.
// [[Rcpp::export]]
void IO_SetParamLinearSVMModelPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<LinearSVMModel*>(paramName) =  Rcpp::as<Rcpp::XPtr<LinearSVMModel>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a LinearSVMModel pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeLinearSVMModelPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("LinearSVMModel",
          *Rcpp::as<Rcpp::XPtr<LinearSVMModel>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "LinearSVMModel";
  return raw_vec;
}

// Deserialize a LinearSVMModel pointer.
// [[Rcpp::export]]
SEXP DeserializeLinearSVMModelPtr(Rcpp::RawVector str)
{
  LinearSVMModel* ptr = new LinearSVMModel();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("LinearSVMModel", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<LinearSVMModel>)ptr);
}


