% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softmax_regression.R
\name{softmax_regression}
\alias{softmax_regression}
\title{Softmax Regression}
\usage{
softmax_regression(
  input_model = NA,
  labels = NA,
  lambda = NA,
  max_iterations = NA,
  no_intercept = FALSE,
  number_of_classes = NA,
  test = NA,
  test_labels = NA,
  training = NA,
  verbose = FALSE
)
}
\arguments{
\item{input_model}{File containing existing model (parameters)
(SoftmaxRegression).}

\item{labels}{A matrix containing labels (0 or 1) for the points in the
training set (y). The labels must order as a row (integer row).}

\item{lambda}{L2-regularization constan.  Default value "0.0001"
(numeric).}

\item{max_iterations}{Maximum number of iterations before termination. 
Default value "400" (integer).}

\item{no_intercept}{Do not add the intercept term to the model.  Default
value "FALSE" (logical).}

\item{number_of_classes}{Number of classes for classification; if
unspecified (or 0), the number of classes found in the labels will be used.
 Default value "0" (integer).}

\item{test}{Matrix containing test dataset (numeric matrix).}

\item{test_labels}{Matrix containing test labels (integer row).}

\item{training}{A matrix containing the training set (the matrix of
predictors, X) (numeric matrix).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value "FALSE"
(logical).}
}
\value{
A list with several components:
\item{output_model}{File to save trained softmax regression model to
  (SoftmaxRegression).}
\item{predictions}{Matrix to save predictions for test dataset into
  (integer row).}
}
\description{
An implementation of softmax regression for classification, which is a
multiclass generalization of logistic regression.  Given labeled data, a
softmax regression model can be trained and saved for future use, or, a
pre-trained softmax regression model can be used for classification of new
points.
}
\details{
This program performs softmax regression, a generalization of logistic
regression to the multiclass case, and has support for L2 regularization. 
The program is able to train a model, load  an existing model, and give
predictions (and optionally their accuracy) for test data.

Training a softmax regression model is done by giving a file of training
points with the "training" parameter and their corresponding labels with the
"labels" parameter. The number of classes can be manually specified with the
"number_of_classes" parameter, and the maximum number of iterations of the
L-BFGS optimizer can be specified with the "max_iterations" parameter.  The
L2 regularization constant can be specified with the "lambda" parameter and
if an intercept term is not desired in the model, the "no_intercept"
parameter can be specified.

The trained model can be saved with the "output_model" output parameter. If
training is not desired, but only testing is, a model can be loaded with the
"input_model" parameter.  At the current time, a loaded model cannot be
trained further, so specifying both "input_model" and "training" is not
allowed.

The program is also able to evaluate a model on test data.  A test dataset
can be specified with the "test" parameter. Class predictions can be saved
with the "predictions" output parameter.  If labels are specified for the
test data with the "test_labels" parameter, then the program will print the
accuracy of the predictions on the given test set and its corresponding
labels.
}
\examples{
# For example, to train a softmax regression model on the data "dataset" with
# labels "labels" with a maximum of 1000 iterations for training, saving the
# trained model to "sr_model", the following command can be used: 

\dontrun{
output <- softmax_regression(training=dataset, labels=labels)
sr_model <- output$output_model
}

# Then, to use "sr_model" to classify the test points in "test_points",
# saving the output predictions to "predictions", the following command can
# be used:

\dontrun{
output <- softmax_regression(input_model=sr_model, test=test_points)
predictions <- output$predictions
}
}
\author{
mlpack developers
}
