% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frommlmm_toeBIC.r
\name{frommlmm_toebic}
\alias{frommlmm_toebic}
\title{Helper that create the selec_XX argument of eBIC_allmodels()}
\usage{
frommlmm_toebic(XX, res.mlmm)
}
\arguments{
\item{XX}{A list of length one, two or three matrices depending on the model. Matrices are n by m matrix, where n=number of individuals, m=number of SNPs, with rownames(X)=individual names, and colnames(X)=SNP names.
Use the same XX you used with the \code{\link{mlmm_allmodels}} function}

\item{res.mlmm}{Output from the \code{\link{mlmm_allmodels}} function}
}
\description{
Helper function that create the selec_XX argument of \code{\link{eBIC_allmodels}} from the output of \code{\link{mlmm_allmodels}}.
}
\examples{
### Additive model ###
\dontrun{
data("mlmm.gwas.AD")

XX = list(Xa)
KK = list(K.add)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateAD, XX, KK)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateAD, sel_XX, KK, ncol(Xa))

# Effects estimations with the selected model
sel_XXclass <- fromeBICtoEstimation(sel_XX, res.eBIC)
eff.estimations <- Estimation_allmodels(floweringDateAD, sel_XXclass, KK)
genotypes.boxplot(Xa, floweringDateAD, effects = eff.estimations)
}

### Additive + dominance model
\dontrun{
data("mlmm.gwas.AD")

XX = list(Xa, Xd)
KK = list(K.add, K.dom)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateAD, XX, KK)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateAD, sel_XX, KK, ncol(Xa))
#the selected model is the null model
}


### Female+Male model
\dontrun{
data("mlmm.gwas.FMI")

XX = list(Xf, Xm)
KK = list(K.female, K.male)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateFMI, XX, KK, female = female, male = male)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateFMI, sel_XX, KK, ncol(Xf), female = female, male = male)
#the selected model is the null model
}



### Female+Male+Interaction model
\dontrun{
data("mlmm.gwas.FMI")

XX = list(Xf, Xm, Xfm)
KK = list(K.female, K.male, K.hybrid)

# GWAS
res_mlmm <- mlmm_allmodels(floweringDateFMI, XX, KK, female = female, male = male)
manhattan.plot(res_mlmm)

# Model selection
sel_XX <- frommlmm_toebic(XX, res_mlmm)
res.eBIC <- eBIC_allmodels(floweringDateFMI, sel_XX, KK, ncol(Xf), female = female, male = male)
#the selected model is the null model
}
}
\seealso{
\code{\link{mlmm_allmodels}} \code{\link{eBIC_allmodels}}
}
