% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_replicate.R
\name{ml_replicate}
\alias{ml_replicate}
\title{Replicate records in a reference sample based on its fitted weights}
\usage{
ml_replicate(
  ml_fit,
  algorithm = c("pp", "trs", "round"),
  verbose = FALSE,
  .keep_original_ids = FALSE
)
}
\arguments{
\item{ml_fit}{A \code{ml_fit} object created by the \code{\link[=ml_fit]{ml_fit()}} family.}

\item{algorithm}{Replication algorithm to use. "trs" is
the 'Truncate, replicate, sample' integerisation algorithm proposed
by Lovelace et al. (2013), "pp" is weighted sampling with
replacement, and "round" is just simple rounding.}

\item{verbose}{If \code{TRUE}, print diagnostic output.}

\item{.keep_original_ids}{If \code{TRUE}, the original individual and group
ids of the reference sample will be kept with suffix '_old'.}
}
\value{
The function returns a replicated sample in data.frame
in the format used in the reference sample of the input \code{ml_fit} object.
}
\description{
This function replicates each entry in a reference sample based on its fitted
weights. This is useful if the result of multiple replication algorithms
are compared to each other, or to generate a full synthetic population
based on the result of a \code{ml_fit} object. Note that, all individual
and group ids of the synthetic population are not the same as those in
the original reference sample, and the total number of groups replicated
is always very close to or equal the sum of the fitted group weights.
}
\examples{
path <- toy_example("Tiny")
fit <- ml_fit(ml_problem = readRDS(path), algorithm = "entropy_o")
syn_pop <- ml_replicate(fit, algorithm = "trs")
syn_pop
}
\references{
\preformatted{ Lovelace, R., & Ballas, D. (2013). ‘Truncate, replicate, sample’:
     A method for creating integer weights for spatial microsimulation.
     Computers, Environment and Urban Systems, 41, 1-11.
}
}
