% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concurrence.R
\name{labelInteractions}
\alias{labelInteractions}
\title{Provides data about interactions between labels}
\usage{
labelInteractions(mld, labelProportion)
}
\arguments{
\item{mld}{\code{mldr} object to analyze}

\item{labelProportion}{A value in the (0,1] range establishing the proportion of minority labels to be included as result. By default at least
3 or 10\% of minority labels are included, or all of them if there are fewer than 3.}
}
\value{
A list with two slots, \code{indexes} and \code{interactions}. The former contains the indexes of the minority labels, sorted from
higher to lower SCUMBLE metric. The latter will provide an element for each of the previous labels, communicating the indexes of the majority
labels it interacts with and the number of samples in which they appear together.
}
\description{
This function facilitates a list with the minority labels most affected by the problem of concurrence with majority labels,
provinding the indexes of the majority labels interacting with each minority and also the number of instances in which they appear together.
}
\examples{

library(mldr)
labelInteractions(birds)
}
\seealso{
\code{\link{remedial}}, \code{\link{concurrenceReport}}
}
