% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_odeparms.R
\name{transform_odeparms}
\alias{transform_odeparms}
\alias{backtransform_odeparms}
\title{Functions to transform and backtransform kinetic parameters for fitting}
\usage{
transform_odeparms(
  parms,
  mkinmod,
  transform_rates = TRUE,
  transform_fractions = TRUE
)

backtransform_odeparms(
  transparms,
  mkinmod,
  transform_rates = TRUE,
  transform_fractions = TRUE
)
}
\arguments{
\item{parms}{Parameters of kinetic models as used in the differential
equations.}

\item{mkinmod}{The kinetic model of class \link{mkinmod}, containing
the names of the model variables that are needed for grouping the
formation fractions before \link{ilr} transformation, the parameter
names and the information if the pathway to sink is included in the model.}

\item{transform_rates}{Boolean specifying if kinetic rate constants should
be transformed in the model specification used in the fitting for better
compliance with the assumption of normal distribution of the estimator. If
TRUE, also alpha and beta parameters of the FOMC model are
log-transformed, as well as k1 and k2 rate constants for the DFOP and HS
models and the break point tb of the HS model.}

\item{transform_fractions}{Boolean specifying if formation fractions
constants should be transformed in the model specification used in the
fitting for better compliance with the assumption of normal distribution
of the estimator. The default (TRUE) is to do transformations.
The g parameter of the DFOP model is also seen as a fraction.
If a single fraction is transformed (g parameter of DFOP or only a single
target variable e.g. a single metabolite plus a pathway to sink), a
logistic transformation is used \code{\link[stats:Logistic]{stats::qlogis()}}. In other cases, i.e. if
two or more formation fractions need to be transformed whose sum cannot
exceed one, the \link{ilr} transformation is used.}

\item{transparms}{Transformed parameters of kinetic models as used in the
fitting procedure.}
}
\value{
A vector of transformed or backtransformed parameters
}
\description{
The transformations are intended to map parameters that should only take on
restricted values to the full scale of real numbers. For kinetic rate
constants and other parameters that can only take on positive values, a
simple log transformation is used. For compositional parameters, such as the
formations fractions that should always sum up to 1 and can not be negative,
the \link{ilr} transformation is used.
}
\details{
The transformation of sets of formation fractions is fragile, as it supposes
the same ordering of the components in forward and backward transformation.
This is no problem for the internal use in \link{mkinfit}.
}
\examples{

SFO_SFO <- mkinmod(
  parent = list(type = "SFO", to = "m1", sink = TRUE),
  m1 = list(type = "SFO"), use_of_ff = "min")

# Fit the model to the FOCUS example dataset D using defaults
FOCUS_D <- subset(FOCUS_2006_D, value != 0) # remove zero values to avoid warning
fit <- mkinfit(SFO_SFO, FOCUS_D, quiet = TRUE)
fit.s <- summary(fit)
# Transformed and backtransformed parameters
print(fit.s$par, 3)
print(fit.s$bpar, 3)

\dontrun{
# Compare to the version without transforming rate parameters (does not work
# with analytical solution, we get NA values for m1 in predictions)
fit.2 <- mkinfit(SFO_SFO, FOCUS_D, transform_rates = FALSE,
  solution_type = "deSolve", quiet = TRUE)
fit.2.s <- summary(fit.2)
print(fit.2.s$par, 3)
print(fit.2.s$bpar, 3)
}

initials <- fit$start$value
names(initials) <- rownames(fit$start)
transformed <- fit$start_transformed$value
names(transformed) <- rownames(fit$start_transformed)
transform_odeparms(initials, SFO_SFO)
backtransform_odeparms(transformed, SFO_SFO)

\dontrun{
# The case of formation fractions (this is now the default)
SFO_SFO.ff <- mkinmod(
  parent = list(type = "SFO", to = "m1", sink = TRUE),
  m1 = list(type = "SFO"),
  use_of_ff = "max")

fit.ff <- mkinfit(SFO_SFO.ff, FOCUS_D, quiet = TRUE)
fit.ff.s <- summary(fit.ff)
print(fit.ff.s$par, 3)
print(fit.ff.s$bpar, 3)
initials <- c("f_parent_to_m1" = 0.5)
transformed <- transform_odeparms(initials, SFO_SFO.ff)
backtransform_odeparms(transformed, SFO_SFO.ff)

# And without sink
SFO_SFO.ff.2 <- mkinmod(
  parent = list(type = "SFO", to = "m1", sink = FALSE),
  m1 = list(type = "SFO"),
  use_of_ff = "max")


fit.ff.2 <- mkinfit(SFO_SFO.ff.2, FOCUS_D, quiet = TRUE)
fit.ff.2.s <- summary(fit.ff.2)
print(fit.ff.2.s$par, 3)
print(fit.ff.2.s$bpar, 3)
}

}
\author{
Johannes Ranke
}
