% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmkin.R
\name{mmkin}
\alias{mmkin}
\title{Fit one or more kinetic models with one or more state variables to one or
more datasets}
\usage{
mmkin(
  models = c("SFO", "FOMC", "DFOP"),
  datasets,
  cores = round(detectCores()/2),
  cluster = NULL,
  ...
)
}
\arguments{
\item{models}{Either a character vector of shorthand names like
\code{c("SFO", "FOMC", "DFOP", "HS", "SFORB")}, or an optionally named
list of \code{\link{mkinmod}} objects.}

\item{datasets}{An optionally named list of datasets suitable as observed
data for \code{\link{mkinfit}}.}

\item{cores}{The number of cores to be used for multicore processing. This
is only used when the \code{cluster} argument is \code{NULL}. On Windows
machines, cores > 1 is not supported, you need to use the \code{cluster}
argument to use multiple logical processors.}

\item{cluster}{A cluster as returned by \code{\link{makeCluster}} to be used
for parallel execution.}

\item{\dots}{Further arguments that will be passed to \code{\link{mkinfit}}.}
}
\value{
A two-dimensional \code{\link{array}} of \code{\link{mkinfit}}
objects that can be indexed using the model names for the first index (row index)
and the dataset names for the second index (column index).
}
\description{
This function calls \code{\link{mkinfit}} on all combinations of models and
datasets specified in its first two arguments.
}
\examples{

\dontrun{
m_synth_SFO_lin <- mkinmod(parent = mkinsub("SFO", "M1"),
                           M1 = mkinsub("SFO", "M2"),
                           M2 = mkinsub("SFO"), use_of_ff = "max")

m_synth_FOMC_lin <- mkinmod(parent = mkinsub("FOMC", "M1"),
                            M1 = mkinsub("SFO", "M2"),
                            M2 = mkinsub("SFO"), use_of_ff = "max")

models <- list(SFO_lin = m_synth_SFO_lin, FOMC_lin = m_synth_FOMC_lin)
datasets <- lapply(synthetic_data_for_UBA_2014[1:3], function(x) x$data)
names(datasets) <- paste("Dataset", 1:3)

time_default <- system.time(fits.0 <- mmkin(models, datasets, quiet = TRUE))
time_1 <- system.time(fits.4 <- mmkin(models, datasets, cores = 1, quiet = TRUE))

time_default
time_1

endpoints(fits.0[["SFO_lin", 2]])

# plot.mkinfit handles rows or columns of mmkin result objects
plot(fits.0[1, ])
plot(fits.0[1, ], obs_var = c("M1", "M2"))
plot(fits.0[, 1])
# Use double brackets to extract a single mkinfit object, which will be plotted
# by plot.mkinfit and can be plotted using plot_sep
plot(fits.0[[1, 1]], sep_obs = TRUE, show_residuals = TRUE, show_errmin = TRUE)
plot_sep(fits.0[[1, 1]])
# Plotting with mmkin (single brackets, extracting an mmkin object) does not
# allow to plot the observed variables separately
plot(fits.0[1, 1])
}

}
\seealso{
\code{\link{[.mmkin}} for subsetting, \code{\link{plot.mmkin}} for
plotting.
}
\author{
Johannes Ranke
}
\keyword{optimize}
