% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parent_solutions.R
\name{SFO.solution}
\alias{SFO.solution}
\title{Single First-Order kinetics}
\usage{
SFO.solution(t, parent_0, k)
}
\arguments{
\item{t}{Time.}

\item{parent_0}{Starting value for the response variable at time zero.}

\item{k}{Kinetic rate constant.}
}
\value{
The value of the response variable at time \code{t}.
}
\description{
Function describing exponential decline from a defined starting value.
}
\examples{

  \dontrun{plot(function(x) SFO.solution(x, 100, 3), 0, 2)}

}
\references{
FOCUS (2006) \dQuote{Guidance Document on Estimating Persistence
  and Degradation Kinetics from Environmental Fate Studies on Pesticides in
  EU Registration} Report of the FOCUS Work Group on Degradation Kinetics,
  EC Document Reference Sanco/10058/2005 version 2.0, 434 pp,
  \url{http://esdac.jrc.ec.europa.eu/projects/degradation-kinetics}
FOCUS (2014) \dQuote{Generic guidance for Estimating Persistence
  and Degradation Kinetics from Environmental Fate Studies on Pesticides in
  EU Registration} Report of the FOCUS Work Group on Degradation Kinetics,
  Version 1.1, 18 December 2014
  \url{http://esdac.jrc.ec.europa.eu/projects/degradation-kinetics}
}
\seealso{
Other parent solutions: 
\code{\link{DFOP.solution}()},
\code{\link{FOMC.solution}()},
\code{\link{HS.solution}()},
\code{\link{IORE.solution}()},
\code{\link{SFORB.solution}()},
\code{\link{logistic.solution}()}
}
\concept{parent solutions}
