% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{getSSB}
\alias{getSSB}
\title{Calculate the SSB of species}
\usage{
getSSB(sim)
}
\arguments{
\item{sim}{An object of class \code{MizerSim}.}
}
\value{
An array (time x species) containing the SSB in grams.
}
\description{
Calculates the spawning stock biomass (SSB) through time of the species in
the \code{MizerSim} class. SSB is calculated as the total mass of all mature
individuals.
}
\examples{
ssb <- getSSB(NS_sim)
ssb[c("1972", "2010"), c("Herring", "Cod")]
}
\seealso{
Other summary functions: 
\code{\link{getBiomass}()},
\code{\link{getDiet}()},
\code{\link{getGrowthCurves}()},
\code{\link{getN}()},
\code{\link{getYieldGear}()},
\code{\link{getYield}()}
}
\concept{summary functions}
\concept{summary_function}
