% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getPredMort}
\alias{getPredMort}
\title{Get total predation mortality rate}
\usage{
getPredMort(object, n, n_pp, n_other, pred_rate, time_range, drop = TRUE)
}
\arguments{
\item{object}{A \code{MizerParams} object or a \code{MizerSim} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{pred_rate}{An array of predation rates of dimension no. sp x no.
community size bins x no. of size bins in whole spectra (i.e. community +
resource, the w_full slot). The array is optional. If it is not provided
it is calculated by the \code{\link[=getPredRate]{getPredRate()}} function.}

\item{time_range}{The time_range can be character or numeric.}

\item{drop}{If \code{TRUE} then any dimension of length 1 will be removed
from the returned array.}
}
\value{
If a \code{MizerParams} object is passed in, the function returns a two
dimensional array (prey species x prey size) based on the abundances also
passed in. If a \code{MizerSim} object is passed in, the function returns a
three dimensional array (time step x prey species x prey size) with the
predation mortality calculated at every time step in the simulation.
Dimensions may be dropped if they have length 1 unless \code{drop = FALSE}.
}
\description{
Calculates the total predation mortality rate \eqn{\mu_{p,i}(w_p)} (in units
of 1/year) on each prey species by prey size:
\deqn{\mu_{p.i}(w_p) = \sum_j {\tt pred\_rate}_j(w_p)\, \theta_{ji}.}{
  \mu_{p.i}(w_p) = \sum_j pred_rate_j(w_p) \theta_{ji}.}
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# With constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get predation mortality at one time step
n <- sim@n[21,,]
n_pp <- sim@n_pp[21,]
getPredMort(params,n,n_pp)
# Get predation mortality at all saved time steps
getPredMort(sim)
# Get predation mortality over the time 15 - 20
getPredMort(sim, time_range = c(15,20))
}
}
\seealso{
Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
