% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\docType{methods}
\name{getCommunitySlope}
\alias{getCommunitySlope}
\alias{getCommunitySlope,MizerSim-method}
\title{Calculate the slope of the community abundance}
\usage{
getCommunitySlope(object, ...)

\S4method{getCommunitySlope}{MizerSim}(object,
  species = 1:nrow(object@params@species_params), biomass = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{MizerSim}.}

\item{...}{Optional parameters include
\itemize{
  \item min_w Minimum weight of species to be used in the calculation.
  \item max_w Maximum weight of species to be used in the calculation.
  \item min_l Minimum length of species to be used in the calculation.
  \item max_l Maximum length of species to be used in the calculation.
}}

\item{species}{Numeric or character vector of species to include in the calculation.}

\item{biomass}{Boolean. If TRUE (default), the abundance is based on biomass, if FALSE the abundance is based on numbers.}
}
\value{
A data frame with slope, intercept and R2 values.
}
\description{
Calculates the slope of the community abundance through time by performing a linear regression on the logged total numerical abundance at weight and logged weights (natural logs, not log to base 10, are used).
You can specify minimum and maximum weight or length range for the species. Lengths take precedence over weights (i.e. if both min_l and min_w are supplied, only min_l will be used).
You can also specify the species to be used in the calculation.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
sim <- project(params, effort=1, t_max=40, dt = 1, t_save = 1)
# Slope based on biomass, using all species and sizes
slope_biomass <- getCommunitySlope(sim)
# Slope based on numbers, using all species and sizes
slope_numbers <- getCommunitySlope(sim, biomass=FALSE)
# Slope based on biomass, using all species and sizes between 10g and 1000g
slope_biomass <- getCommunitySlope(sim, min_w = 10, max_w = 1000)
# Slope based on biomass, using only demersal species and sizes between 10g and 1000g
dem_species <- c("Dab","Whiting","Sole","Gurnard","Plaice","Haddock", "Cod","Saithe")
slope_biomass <- getCommunitySlope(sim, species = dem_species, min_w = 10, max_w = 1000)
}
}
