% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{extract_av_cols}
\alias{extract_av_cols}
\title{Extract the availabilites matrix from the dataset using a column name prefix}
\usage{
extract_av_cols(data, prefix)
}
\arguments{
\item{data}{The dataset used in the model}

\item{prefix}{The prefix of the availability columns, i.e. avail_}
}
\value{
Matrix of availabilities for alternatives and the number of choice observations
}
\description{
Extract the availabilites matrix from the dataset using a column name prefix
}
\examples{
data("Train", package="mlogit")
Train$ID <- Train$id
Train$CHOICE <- as.numeric(Train$choice)
Train$avail_A <- sample(2, replace=TRUE, size=nrow(Train))-1
Train$avail_B <- sample(2, replace=TRUE, size=nrow(Train))-1
extract_av_cols(Train, 'avail_')
}
