% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_stats.R
\name{summary.mixl}
\alias{summary.mixl}
\title{Create a model summary}
\usage{
\method{summary}{mixl}(object, ...)
}
\arguments{
\item{object}{The mixl output to summarize.}

\item{...}{Options to pass to summarize (currently).}
}
\value{
A summary object for a mixl model
}
\description{
\code{summary} is an S3 method for the class mixl, which adds metrics of goodness of fit
}
\examples{
\donttest{
	data("Train", package="mlogit")
	Train$ID <- Train$id
	Train$CHOICE <- as.numeric(Train$choice)
	    
	mnl_test <- "
	U_A = @B_price * $price_A / 1000 + @B_time * $time_A / 60;
	U_B = @asc + @B_price * $price_B / 1000 + @B_timeB * $time_B / 60;
	"

	model_spec <- mixl::specify_model(mnl_test, Train)

	#only take starting values that are needed
	est <- stats::setNames(c(1, 1,1,1), c("asc", "B_price", "B_time", "B_timeB"))
	availabilities <- mixl::generate_default_availabilities(
		Train, model_spec$num_utility_functions
	)

	model <- mixl::estimate(model_spec, est, Train, availabilities = availabilities)
	summary(model)
}
}
