% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixedBayes-package.R
\name{mixedBayes-package}
\alias{mixedBayes-package}
\title{Bayesian Longitudinal Regularized Quantile Mixed Model}
\description{
In this package, we provide a set of Bayesian regularized variable selection methods under the mixed effect models (random intercept and slope model, random intercept model) to dissect important gene - environment interactions for longitudinal studies. A Bayesian quantile regression has been adopted to accommodate data contamination and heavy-tailed distributions in the response/ phenotype. The default method (the proposed method) conducts variable selection by accounting the group level selection on the interaction effects under random intercept and slope model. In particular, the spike--and--slab priors are imposed on both individual and group levels to identify important main and interaction effects.
In addition to the default method, users can also choose different selection structures for the interaction effects (group-level or individual-level), random intercept model, methods without spike--and--slab priors and non-robust methods. In total, \emph{mixedBayes} provides 16 different methods (8 robust and 8 non-robust) under both mixed effects models. Among them, robust methods with spike--and--slab priors and the robust method for both individual level selection and group level selection under both mixed effects models have been developed for the first time. Please read the Details below for how to configure the method used.
}
\details{
The user friendly, integrated interface \strong{mixedBayes()} allows users to flexibly choose the fitting methods by specifying the following parameter:
\tabular{rl}{
slope: \tab whether to use random intercept and slope model.\cr\cr
robust: \tab whether to use robust methods for modelling.\cr\cr
quant: \tab to specify different quantiles when using robust methods.\cr\cr
structure: \tab structure for interaction effects.\cr\cr
sparse: \tab whether to use the spike-and-slab priors to impose sparsity.
}

The function mixedBayes() returns a mixedBayes object that contains the posterior estimates of each coefficients.
S3 generic functions selection()and print() are implemented for mixedBayes objects.
selection() takes a mixedBayes object and returns the variable selection results.
}
\references{
Fan, K., Wang, W. and Wu, C. (2022). Bayesian Regularized Quantile Mixed Model for Lipid - Environment Interactions in a Longitudinal Study. (to be submitted)

Zhou, F., Ren, J.,  Li, G., Jiang, Y., Li, X., Wang, W. and Wu, C. (2019). Penalized Variable Selection for Lipid-Environment Interactions in a Longitudinal Lipidomics Study.
{\emph{Genes}, 10(12), 1002} \doi{10.3390/genes10121002}

Ren, J., Zhou, F., Li, X., Ma, S., Jiang, Y. and Wu, C. (2022). Robust Bayesian variable selection for gene-environment interactions.
{\emph{Biometrics}, (in press)} \doi{10.1111/biom.13670}

Ren, J., Zhou, F., Li, X., Ma, S., Jiang, Y. and Wu, C. (2020). roben: Robust Bayesian Variable Selection for Gene-Environment Interactions.
R package version 0.1.1. \url{https://CRAN.R-project.org/package=roben}

Wu, C., and Ma, S. (2015). A selective review of robust variable selection with applications in bioinformatics.
{\emph{Briefings in Bioinformatics}, 16(5), 873–883} \doi{10.1093/bib/bbu046}

Zhou, F., Ren, J., Lu, X., Ma, S. and Wu, C. (2021). Gene–Environment Interaction: a Variable Selection Perspective.
{\emph{Epistasis. Methods in Molecular Biology.} 2212:191–223} \url{https://link.springer.com/protocol/10.1007/978-1-0716-0947-7_13}

Ren, J., Zhou, F., Li, X., Chen, Q., Zhang, H., Ma, S., Jiang, Y. and Wu, C. (2020) Semi-parametric Bayesian variable selection for gene-environment interactions.
{\emph{Statistics in Medicine}, 39: 617– 638} \doi{10.1002/sim.8434}

Ren, J., Zhou, F., Li, X., Wu, C. and Jiang, Y. (2019) spinBayes: Semi-Parametric Gene-Environment Interaction via Bayesian Variable Selection.
R package version 0.1.0. \url{https://CRAN.R-project.org/package=spinBayes}

Wu, C., Jiang, Y., Ren, J., Cui, Y. and Ma, S. (2018). Dissecting gene-environment interactions: A penalized robust approach accounting for hierarchical structures.
{\emph{Statistics in Medicine}, 37:437–456} \doi{10.1002/sim.7518}


Wu, C., Cui, Y., and Ma, S. (2014). Integrative analysis of gene–environment interactions under a multi–response partially linear varying coefficient model.
{\emph{Statistics in Medicine}, 33(28), 4988–4998} \doi{10.1002/sim.6287}


Wu, C., Zhong, P.S. and Cui, Y. (2013). High dimensional variable selection for gene-environment interactions.
{\emph{Technical Report. Michigan State University.}}
}
\seealso{
\code{\link{mixedBayes}}
}
\keyword{overview}
