% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim}
\alias{trim}
\title{Trim Whitespace from String}
\usage{
trim(x, side = c("both", "left", "right"), check = TRUE)
}
\arguments{
\item{x}{a character vector.}

\item{side}{a character string indicating the side on which to remove whitespace,
i.e., \code{"both"} (default), \code{"left"} or \code{"right"}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a character vector with whitespaces removed from the vector specified in \code{x}.
}
\description{
This function removes whitespace from start and/or end of a string.
}
\details{
Note that this function is based on the \code{str_trim()} function in the \pkg{stringr} package by Hadley Wickham.
}
\examples{
x <- "  string  "

# Remove whitespace at both sides
trim(x)

# Remove whitespace at the left side
trim(x, side = "left")

# Remove whitespace at the right side
trim(x, side = "right")
}
\references{
Wickham, H. (2019). \emph{stringr: Simple, consistent wrappers for common string operations}.
R package version 1.4.0. \url{https://CRAN.R-project.org/package=stringr}
}
\seealso{
\code{\link{mgsub}}, \code{\link{stromit}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
