% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{parameters}
\alias{parameters}
\alias{parameters.standist}
\alias{parameters.trans_standist}
\alias{parameters.mixdist}
\alias{parameters.trans_mixdist}
\alias{parameters.compdist}
\alias{parameters.trans_compdist}
\alias{parameters.comp_fit}
\title{Extract Model Parameters}
\usage{
parameters(O)

\method{parameters}{standist}(O)

\method{parameters}{trans_standist}(O)

\method{parameters}{mixdist}(O)

\method{parameters}{trans_mixdist}(O)

\method{parameters}{compdist}(O)

\method{parameters}{trans_compdist}(O)

\method{parameters}{comp_fit}(O)
}
\arguments{
\item{O}{an object for which the extraction of model parameters is meaningful.}
}
\value{
Vector (for standard distributions) or list (in the case of mixture/composite distribution)
        of parameters extracted from the object.

        For a fitted object of class comp_fit returns vector of fitted parameters.
}
\description{
\code{parameters} is a generic function which extracts parameters from \code{\link{mistr}} distribution objects.
}
\examples{
N <- normdist(1, 3)
parameters(N)

C <- cauchydist()
M <- mixdist(N, C, weights = c(0.5, 0.5))
parameters(M)
}
\seealso{
\code{\link[stats]{weights}}, \code{\link{breakpoints}}
}
