context('mirtTwo')

test_that('poly', {
    modp1 <- mirt(Science, 1)
    expect_is(modp1, 'ConfirmatoryClass')          
    modp2 <- mirt(Science, 2)
    expect_is(modp2, 'ExploratoryClass')
    modp3 <- mirt(Science, 1, constrain = list(c(1,5)), parprior = list(c(2,'norm',0,1)))
    expect_is(modp3, 'ConfirmatoryClass')
    modp4 <- mirt(Science, 1, itemtype = c(rep('graded',3), 'nominal'))
    expect_is(modp4, 'ConfirmatoryClass')
    modp5 <- mirt(Science, 1, itemtype = c(rep('graded',3), 'gpcm'), SE = TRUE)
    expect_is(modp5, 'ConfirmatoryClass')
    
    fm1 <- fscores(modp1, verbose = FALSE)
    expect_is(fm1, 'matrix')
    fm2 <- fscores(modp2, rotate = 'oblimin', verbose = FALSE)
    expect_is(fm2, 'matrix')
    fm3 <- fscores(modp3, rotate = 'oblimin', full.scores = TRUE, verbose = FALSE)
    expect_is(fm3, 'matrix')
    fm4 <- fscores(modp4, verbose = FALSE)
    expect_is(fm4, 'matrix')
    fm5 <- fscores(modp5, verbose = FALSE)
    expect_is(fm5, 'matrix')
    
    cof1 <- coef(modp1)
    expect_is(cof1, 'list')
    cof2 <- coef(modp2)
    expect_is(cof2, 'list')
    IP1 <- itemplot(modp1, 1)
    IP2 <- itemplot(modp2, 1)
    expect_is(IP1, 'trellis')
    expect_is(IP2, 'trellis')
    
    ##rating scale test
    set.seed(1234)
    a <- matrix(rep(1/1.702, 10))
    d <- matrix(c(1,0.5,-.5,-1), 10, 4, byrow = TRUE)
    c <- seq(-1, 1, length.out=10)
    data <- simdata(a, d + c, 2000, itemtype = rep('graded',10))
    sv <- mirt(data, 1, itemtype = 'grsm', pars = 'values')
    sv[,5] <- c(as.vector(t(cbind(a,d,c))),0,1)    
    grsm <- mirt(data, 1, itemtype = 'grsm', pars = sv, calcNull= FALSE)
    rsm <- mirt(data, 1, itemtype = 'rsm', calcNull= FALSE)
    expect_is(grsm, 'ConfirmatoryClass')    
    expect_is(rsm, 'ConfirmatoryClass')    
    
    #item and test info
    Theta <- matrix(seq(-4,4,.01))
    x <- extract.item(modp1, 1)
    iinfo <- iteminfo(x, Theta)
    expect_is(iinfo, 'matrix')    
    tinfo <- testinfo(modp1, Theta)
    expect_is(tinfo, 'matrix')
    
})