% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchers.R
\name{launch_local}
\alias{launch_local}
\alias{launch_remote}
\title{Launch Daemon}
\usage{
launch_local(url, ..., tls = NULL, .compute = "default")

launch_remote(
  url,
  remote = remote_config(),
  ...,
  tls = NULL,
  .compute = "default"
)
}
\arguments{
\item{url}{the character host URL or vector of host URLs, including the port
    to connect to (and optionally for websockets, a path), e.g.
    tcp://hostname:5555' or 'ws://10.75.32.70:5555/path'

    \strong{or} integer index value, or vector of index values, of the
    dispatcher URLs, or 1L for the host URL (when not using dispatcher).

    \strong{or} for \code{launch_remote} only, a \sQuote{miraiCluster} or
    \sQuote{miraiNode}.}

\item{...}{(optional) additional arguments passed through to
\code{\link{daemon}}. These include \sQuote{autoexit}, \sQuote{cleanup},
\sQuote{output}, \sQuote{maxtasks}, \sQuote{idletime}, \sQuote{walltime}
and \sQuote{timerstart}.}

\item{tls}{[default NULL] required for secure TLS connections over tls+tcp or
wss. Zero-configuration TLS certificates generated by \code{\link{daemons}}
are automatically passed to the daemon, without requiring to be specified
here. Otherwise, supply \strong{either} the character path to a file
containing X.509 certificate(s) in PEM format, comprising the certificate
authority certificate chain, \strong{or} a length 2 character vector
comprising [i] the certificate authority certificate chain and [ii] the
empty character ''.}

\item{.compute}{[default 'default'] character value for the compute profile
to use (each compute profile has its own independent set of daemons).}

\item{remote}{required only for launching remote daemons, a configuration
generated by \code{\link{remote_config}} or \code{\link{ssh_config}}. An
empty \code{\link{remote_config}} does not effect any daemon launches but
returns the shell commands for deploying manually on remote machines.}
}
\value{
For \strong{launch_local}: Invisible NULL.

For \strong{launch_remote}: A character vector of daemon launch
    commands, classed as \sQuote{miraiLaunchCmd}. The printed output may be
    directly copy / pasted to the remote machine.
}
\description{
\code{launch_local} spawns a new background \code{Rscript} process calling
    \code{\link{daemon}} with the specified arguments.

\code{launch_remote} returns the shell command for deploying daemons as a
    character vector. If a configuration generated by
    \code{\link{remote_config}} or \code{\link{ssh_config}} is supplied then
    this is used to launch the daemon on the remote machine.
}
\details{
These functions may be used to re-launch daemons that have exited
    after reaching time or task limits.

    If daemons have been set, the generated command will automatically
    contain the argument \sQuote{rs} specifying the length 7 L'Ecuyer-CMRG
    random seed supplied to the daemon. The values will be different each
    time the function is called.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

daemons(url = host_url(ws = TRUE), dispatcher = FALSE)
status()
launch_local(status()$daemons, maxtasks = 10L)
launch_remote(1L, maxtasks = 10L)
Sys.sleep(1)
status()
daemons(0)

daemons(n = 2L, url = host_url(tls = TRUE))
status()
launch_local(1:2, idletime = 60000L, timerstart = 1L)
launch_remote(1:2, idletime = 60000L, timerstart = 1L)
Sys.sleep(1)
status()
daemons(0)

}

}
