% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{eval_mirai}
\alias{eval_mirai}
\alias{mirai}
\title{mirai (Evaluate Async)}
\usage{
eval_mirai(.expr, ..., .args = list(), .timeout = NULL)

mirai(.expr, ..., .args = list(), .timeout = NULL)
}
\arguments{
\item{.expr}{an expression to evaluate in a new R process. This may be of
arbitrary length, wrapped in \{\} if necessary.}

\item{...}{(optional) named arguments specifying variables contained in '.expr'.}

\item{.args}{(optional) list supplying arguments to '.expr' (used in addition
to or instead of named arguments specified as '...').}

\item{.timeout}{(optional) integer value in milliseconds or NULL for no
timeout. A 'mirai' will resolve to an 'errorValue' 5 (timed out) if
evaluation exceeds this limit.}
}
\value{
A 'mirai' object.
}
\description{
Evaluate an expression asynchronously in a new background R process. This
    function will return immediately with a 'mirai', which will resolve to
    the evaluated result once complete.
}
\details{
This function will return a 'mirai' object immediately.

    The value of a 'mirai' may be accessed at any time at \code{$data}, and
    if yet to resolve, an 'unresolved' logical NA will be returned instead.

    \code{\link{unresolved}} may also be used on a 'mirai', which returns TRUE
    only if a 'mirai' has yet to resolve and FALSE otherwise. This is suitable
    for use in control flow statements such as \code{while} or \code{if}.

    Alternatively, to call (and wait for) the result, use
    \code{\link{call_mirai}} on the returned 'mirai' object. This will block
    until the result is returned.

    The expression '.expr' will be evaluated in a new R process in a clean
    environment consisting of the named objects passed as '...' only (along
    with objects in the list '.args', if supplied).

    If an error occurs in evaluation, the error message is returned as a
    character string of class 'miraiError' and 'errorValue'.
    \code{\link{is_mirai_error}} may be used to test for this, otherwise
    \code{\link{is_error_value}} will also include other errors such as
    timeouts.

    \code{\link{mirai}} is an alias for \code{\link{eval_mirai}}.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

m <- mirai(x + y + 1, x = 2, y = 3)
m
m$data
Sys.sleep(0.2)
m$data

df1 <- data.frame(a = 1, b = 2)
df2 <- data.frame(a = 3, b = 1)
m <- mirai(as.matrix(rbind(df1, df2)), .args = list(df1, df2), .timeout = 1000)
call_mirai(m)$data

m <- mirai({
  res <- rnorm(n)
  res / rev(res)
}, n = 1e6)
while (unresolved(m)) {
  cat("unresolved\n")
  Sys.sleep(0.1)
}
str(m$data)

file <- tempfile()
cat("r <- rnorm(n)", file = file)
n <- 10L
m <- mirai({source(file, local = TRUE); r}, .args = list(file, n))
call_mirai(m)[["data"]]
unlink(file)

}

}
