% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.pkgDepGraph.R
\name{plot.pkgDepGraph}
\alias{plot.pkgDepGraph}
\title{Plots a package dependency graph.}
\usage{
\method{plot}{pkgDepGraph}(x, pkgsToHighlight, main = paste(attr(x, "pkgs"),
  collapse = ", "), legendPosition = c(-1.2, -1), shape = "circle",
  vertex.size = 8, cex = 1, ...)
}
\arguments{
\item{x}{pkgDepGraph object}

\item{pkgsToHighlight}{Optional character vector with names of package to hightlight. If missing, defaults to packages used in original call to \code{\link{makeDepGraph}}}

\item{main}{Title of plot}

\item{legendPosition}{Numeric vector of length 2, indicating (x, y) position of edge legend. Both values should be in the range [-1; 1].  If NULL, the edge legend is not displayed.}

\item{shape}{Shape of edge.  See \code{\link[igraph]{igraph.plotting}}. Could be "none", "circle", "square", ...}

\item{vertex.size}{Size of vertex shape. See \code{\link[igraph]{igraph.plotting}}}

\item{cex}{Vertex label size.}

\item{...}{Ignored}
}
\description{
Plots a package dependency graph.
}
\examples{
tags <- "chron"

# Plot using defaults
pdb <- cranJuly2014

\dontrun{
  pdb <- pkgAvail(
    repos = c(CRAN = "http://mran.microsoft.com"),
    type="source"
  )
}

dg <- makeDepGraph(tags, availPkgs = pdb  , includeBasePkgs=FALSE, suggests=TRUE, enhances=TRUE)

set.seed(42); 
plot(dg)

# Move edge legend to top left
set.seed(42); 
plot(dg, legendPosition=c(-1, 1))

# Change font size and shape size
set.seed(42); 
plot(dg, legendPosition=c(-1, 1), vertex.size=20,  cex=0.5)


# Move vertex legend to top right
set.seed(42); 
plot(dg, legendPosition=c(1, 1), vertex.size=20,  cex=0.5)

}
\seealso{
Other dependency functions: \code{\link{basePkgs}},
  \code{\link{makeDepGraph}}, \code{\link{pkgDep}}
}

