toMIM <- function(data) UseMethod("toMIM", data)

toMIM.data.frame <- function(data){
  nt <- .extract.nt(data)
  vs <- .nt.to.varspec(nt)
  mdata <- data
  for (j in 1:ncol(mdata))
    ###for (j in which(nt$factor))
    mdata[,j] <- as.numeric(mdata[,j])
  var.letter <- .look.up.mim.names(names(mdata),nt,"to.mim")
  str4     <- unlist( lapply( as.vector(t(mdata)), .float.to.string, n.digits=5, width=15))
  mim.cmd("clear; clear output")
  lapply(vs, mim.cmd)
  mim.cmd(paste("Read", paste(var.letter, collapse=' ')))
  lapply(.partition.mim.input(str4),mim.cmd)
  mim.cmd("!")    
}

toMIM.gmData <- function(data){
  mim.cmd("clear; clear output")
  if (.dataOrigin(data)=="data.frame"){
    .df.to.mim(data)
  } else {
    if (.dataOrigin(data)=="suffStats")
      .ss.to.mim(data)
  }
}

toMIM.gmData <- function(data){
  mim.cmd("clear; clear output")
  switch(.dataOrigin(data),
         "data.frame" = {.df.to.mim(data)},
         "suffStats"  = {.ss.to.mim(data)},
         "table"      = {.table.to.mim(data)}
         )
}

.table.to.mim <- function(data){
  vs <-.nt.to.varspec(data)
  ss <- data$letter
  ##print(ss)
  ss <- ss[length(ss):1]
  ##print(ss)
  s  <- paste("Statread", paste(ss, collapse=''))
  res <- as.vector(observations(data))
  mim.cmd("# Suff stats")
  lapply(vs, mim.cmd)
  mim.cmd(s)
  lapply(.partition.mim.input(res),mim.cmd)
  mim.cmd("!", look.nice=FALSE)    

}









.ss.to.mim <- function(data){
  vs <-.nt.to.varspec(data)
  s  <- paste("Statread", paste(data$letter, collapse=''))
  res <- observations(data)
  str4     <- unlist( lapply( as.vector(t(res)), .float.to.string, n.digits=5, width=15))    
  mim.cmd("# Suff stats")
  lapply(vs, mim.cmd)
  mim.cmd(s)
  lapply(.partition.mim.input(str4),mim.cmd)
  mim.cmd("!", look.nice=FALSE)    
}



.df.to.mim <- function(data,file=NULL){

  nt <- as.data.frame(data)
  vs <- .nt.to.varspec(nt)
  mdata <- observations(data)
  for (j in 1:ncol(mdata))
    mdata[,j] <- as.numeric(mdata[,j])
  str4     <- unlist( lapply( as.vector(t(mdata)), .float.to.string, n.digits=3, width=2))    
  var.letter <- .look.up.mim.names(names(mdata),nt,"to.mim")

  if (is.null(file)){
    #specfile <- tempfile(pattern="mimR_df2mim")
    #file     <- paste(specfile,".txt",sep='')
    specfile <- "mimR_df2mim"
    file     <- paste(getwd(),"\\",specfile,".txt",sep='')

  } else {
    if (length(grep(":", file))==0)
      file <- paste(getwd(),"\\",file,sep='')
  }
  tmp <- proc.time()
  #cat("Writing MIM data file (in working dir)", specfile,"... ")
  write("%\n% DATA FILE AUTOMATICALLY GENERATED BY mimR", file, append=FALSE)
  write(paste("% TIME:", date(),  "%"), file, append=TRUE)
  write(paste("% FILE:", file,  "\n%"), file, append=TRUE)

  lapply(vs, write, file,append=TRUE)
  write(paste("Read", paste(var.letter, collapse=' ')), file, append=TRUE)  

  write(str4, file, append=TRUE, ncolumns=20)
  write("!", file, append=TRUE)

  str  <- paste("input", file, ";", sep=' ');
  
  str  <- paste("clear; clear output;","input", file, ";", sep=' ');
  mim.cmd(paste("#", str));
  mim.cmd(str, look.nice=FALSE);
  
  #cat("Time taken:", (proc.time()-tmp)[3],"\n")
  mim.cmd(paste("#", str));
  mim.cmd(str, look.nice=FALSE);

  return(file)
}



.df.to.mim.old <- function(data){
  tmp <- proc.time()
  nt <- as.data.frame(data)
  vs <- .nt.to.varspec(nt)
  mdata <- observations(data)
  for (j in 1:ncol(mdata))
    mdata[,j] <- as.numeric(mdata[,j])
  str4     <- unlist( lapply( as.vector(t(mdata)), .float.to.string, n.digits=5, width=15))    
  var.letter <- .look.up.mim.names(names(mdata),nt,"to.mim")
    
  lapply(vs, mim.cmd)
  mim.cmd(paste("Read", paste(var.letter, collapse=' ')))
  lapply(.partition.mim.input(str4),mim.cmd)
  mim.cmd("!")
  cat("Time taken:", proc.time()-tmp,"\n")
}
