% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfm_exact.R
\name{kfm_exact}
\alias{kfm_exact}
\title{Create an exact kernel feature map}
\usage{
kfm_exact(kernel = "polynomial", degree = 2, const = 1)
}
\arguments{
\item{kernel}{A character determining the kernel to use.  Currently, only
\code{'radial'} is implemented.}

\item{degree}{A numeric value (default 2) that provides the degree for
\code{kernel} = 'polynomial'}

\item{const}{A numeric value (default 1) for the constant term when \code{kernel = 'polynomial'}.}
}
\value{
An object of class \code{kfm_exact} with the following components,
returned from the inputs:
\itemize{
\item \code{kernel}
\item \code{degree}
\item \code{const}
}
}
\description{
For some kernels, it is possible to create the exact features from given
data. This function stores the information needed to build those exact
features.
}
\details{
Currently, the following kernels are supported:
\itemize{
\item \code{'polynomial'}, with \code{degree} = d and \code{const} = c
}
}
\examples{
df <- data.frame(
  X1 = c(2,   3,   4,   5,   6, 7, 8),
  X2 = c(1, 1.2, 1.3, 1.4, 1.1, 7, 1),
  X3 = rnorm(7)
)

fit <- kfm_exact(kernel = "polynomial", degree = 2, const = 1)
fm <- build_fm(fit, df)

}
\seealso{
Other kernel feature map functions: 
\code{\link{kfm_nystrom}()}
}
\author{
Sean Kent
}
\concept{kernel feature map functions}
