% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_nb.R
\name{rescale_nb}
\alias{rescale_nb}
\title{Rescale native born populations to match global differences in births and deaths over period}
\usage{
rescale_nb(m1, m2, b, d, verbose = FALSE)
}
\arguments{
\item{m1}{Matrix of migrant stock totals at time \emph{t}. Rows in the matrix correspond to place of birth and columns to place of residence at time \emph{t}}

\item{m2}{Matrix of migrant stock totals at time \emph{t}+1. Rows in the matrix correspond to place of birth and columns to place of residence at time \emph{t}+1.}

\item{b}{Vector of the number of births between time \emph{t} and \emph{t}+1 in each region.}

\item{d}{Vector of the number of deaths between time \emph{t} and \emph{t}+1 in each region.}

\item{verbose}{Logical value to indicate the print the parameter estimates at each iteration. By default \code{FALSE}.}
}
\value{
List with adjusted \code{m1} and \code{m2}.
}
\description{
This function is predominantly intended to be used within the ffs routines in the migest package. Adjustment to ensure that global differences in stocks match the global demographic changes from births and deaths.
}
\examples{
dn <- LETTERS[1:4]
P1 <- matrix(data = c(1000, 100, 10, 0, 55, 555, 50, 5, 80, 40, 800, 40, 20, 25, 20, 200),
             nrow = 4, ncol = 4, dimnames = list(pob = dn, por = dn), byrow = TRUE)
P2 <- matrix(data = c(950, 100, 60, 0, 80, 505, 75, 5, 90, 30, 800, 40, 40, 45, 0, 180),
             nrow = 4, ncol = 4, dimnames = list(pob = dn, por = dn), byrow = TRUE)
# display with row and col totals
addmargins(A = P1)
addmargins(A = P2)

# births and deaths
b <- rep(x = 10, 4)
d <- rep(x = 5, 4)
# no change in stocks, but 20 more births than deaths...
sum(P2 - P1) + sum(b - d)
# rescale
y <- rescale_nb(m1 = P1, m2 = P2, b = b, d = d)
y
sum(y$m1_adj - y$m2_adj) + sum(b - d)

# check for when extra is positive and odd
d[1] <- 31
d
sum(P2 - P1) - sum(b - d)
# rescale
y <- rescale_nb(m1 = P1, m2 = P2, b = b, d = d)
sum(y$m1_adj - y$m2_adj) - sum(b - d)
}
\seealso{
\code{\link{ipf3_qi}}, \code{\link{ffs_diff}}
}
\author{
Guy J. Abel
}
