% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Selector.R
\name{SelectorScalar}
\alias{SelectorScalar}
\title{Selector making use of Scalors}
\description{
Base class inheriting from \code{\link{Selector}} for selection operations that make use of scalar values, generated by \code{\link{Scalor}}.
}
\section{Inheriting}{

\code{SelectorScaling} is an abstract base class and should be inherited from. Inheriting classes should implement the private \verb{$.select_scalar()}
function. During \verb{$operate()}, the \verb{$.select_scalar()} function is called, it should have three arguments, similar to \code{\link{Selector}}'s \verb{$.select()} function.
\code{values} and \code{n_select} are as given to \verb{$.select()} of the \code{\link{Selector}}. The \code{fitnesses} argument is first scaled by the associated \code{\link{Scalor}}
and then passed on as a \code{numeric} vector.

Typically, \verb{$initialize()} should also be overloaded when inheriting.
}

\seealso{
Other base classes: 
\code{\link{Filtor}},
\code{\link{FiltorSurrogate}},
\code{\link{MiesOperator}},
\code{\link{Mutator}},
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{OperatorCombination}},
\code{\link{Recombinator}},
\code{\link{RecombinatorPair}},
\code{\link{Scalor}},
\code{\link{Selector}}

Other selectors: 
\code{\link{Selector}},
\code{\link{dict_selectors_best}},
\code{\link{dict_selectors_maybe}},
\code{\link{dict_selectors_null}},
\code{\link{dict_selectors_proxy}},
\code{\link{dict_selectors_random}},
\code{\link{dict_selectors_sequential}},
\code{\link{dict_selectors_tournament}}
}
\concept{base classes}
\concept{selectors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Selector]{miesmuschel::Selector}} -> \code{SelectorScalar}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{scalor}}{(\code{\link{Scalor}})\cr
\code{\link{Scalor}} used to scalarize fitnesses for selection.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SelectorScalar-new}{\code{SelectorScalar$new()}}
\item \href{#method-SelectorScalar-prime}{\code{SelectorScalar$prime()}}
\item \href{#method-SelectorScalar-clone}{\code{SelectorScalar$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorScalar-new"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorScalar-new}{}}}
\subsection{Method \code{new()}}{
Initialize base class components of the \code{SelectorScalar}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorScalar$new(
  scalor = ScalorSingleObjective$new(),
  is_deterministic = FALSE,
  param_classes = c("ParamLgl", "ParamInt", "ParamDbl", "ParamFct"),
  param_set = ps(),
  supported = scalor$supported,
  packages = character(0),
  dict_entry = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scalor}}{(\code{\link{Scalor}})\cr
\code{\link{Scalor}} to use to generate scalar values from multiple objectives, if multi-objective optimization is performed.
Initialized to \code{\link{ScalorSingleObjective}}: Doing single-objective optimization normally, throwing an error if used
in multi-objective setting: In that case, a \code{\link{Scalor}} needs to be explicitly chosen.}

\item{\code{is_deterministic}}{(\code{logical(1)})\cr
Whether the \code{\link{Selector}} is deterministic. Setting this to \code{TRUE} adds a configuration parameter \code{shuffle_selection} (initialized to \code{TRUE})
that causes the selection to be shuffled.}

\item{\code{param_classes}}{(\code{character})\cr
Classes of parameters that the operator can handle. May contain any of \code{"ParamLgl"}, \code{"ParamInt"}, \code{"ParamDbl"}, \code{"ParamFct"}.
Default is all of them.\cr
The \verb{$param_classes} field will reflect this value.}

\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}} | \code{list} of \code{expression})\cr
Strategy parameters of the operator. This should be created by the subclass and given to \code{super$initialize()}.
If this is a \code{\link[paradox:ParamSet]{ParamSet}}, it is used as the \code{MiesOperator}'s \code{\link[paradox:ParamSet]{ParamSet}}
directly. Otherwise it must be a \code{list} of expressions e.g. created by \code{alist()} that evaluate to \code{\link[paradox:ParamSet]{ParamSet}}s,
possibly referencing \code{self} and \code{private}.
These \code{\link[paradox:ParamSet]{ParamSet}} are then combined using a \code{\link[paradox:ParamSetCollection]{ParamSetCollection}}.
Default is the empty \code{\link[paradox:ParamSet]{ParamSet}}.\cr
The \verb{$param_set} field will reflect this value.}

\item{\code{supported}}{(\code{character})\cr
Subset of \code{"single-crit"} and \code{"multi-crit"}, indicating wether single and / or multi-criterion optimization is supported.
Default to the supported set of \code{scalor}.\cr
The \verb{$supported} field will reflect this value.}

\item{\code{packages}}{(\code{character})
Packages that need to be loaded for the operator to function. This should
be declared so these packages can be loaded when operators run on parallel
instances. Default is \code{character(0)}.\cr
The \verb{$packages} field will reflect this values.}

\item{\code{dict_entry}}{(\code{character(1)} | \code{NULL})\cr
Key of the class inside the \code{\link[mlr3misc:Dictionary]{Dictionary}} (usually one of
\code{\link{dict_mutators}}, \code{\link{dict_recombinators}}, \code{\link{dict_selectors}}), where it can
be retrieved using a \link[=mut]{short access function}. May be \code{NULL} if the operator
is not entered in a dictionary.\cr
The \verb{$dict_entry} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorScalar-prime"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorScalar-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the wrapped operator
given to \code{scalor} during construction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorScalar$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorScalar-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorScalar-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorScalar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
