% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{midas_mmm_sim}
\alias{midas_mmm_sim}
\title{Simulate MMM MIDAS regression model}
\usage{
midas_mmm_sim(
  n,
  m,
  theta,
  intercept,
  pmmm,
  ar.x,
  ar.y,
  rand.gen = rnorm,
  n.start = NA,
  ...
)
}
\arguments{
\item{n}{number of observations to simulate.}

\item{m}{integer, frequency ratio}

\item{theta}{vector, restriction coefficients for high frequency variable}

\item{intercept}{vector of length 1, intercept for the model.}

\item{pmmm}{vector of length 2, slope for the MMM term and MMM parameter}

\item{ar.x}{vector, AR parameters for simulating high frequency variable}

\item{ar.y}{vector, AR parameters for AR part of the model}

\item{rand.gen}{function, a function for generating the regression innovations, default is \code{rnorm}}

\item{n.start}{integer, length of a 'burn-in' period. If NA, the default, a reasonable value is computed.}

\item{...}{additional parameters to rand.gen}
}
\value{
a list
}
\description{
Simulate MMM MIDAS regression model
}
\examples{

nnbeta <- function(p, k) nbeta(c(1,p),k)

dgp <- midas_mmm_sim(250, m = 12, theta = nnbeta(c(2, 4), 24), 
                           intercept = c(1), pmmm = c(1.5, 1), 
                           ar.x = 0.9, ar.y = 0.5, n.start = 100)
z <- cbind(1, mls(dgp$y, 1:2, 1))
colnames(z) <- c("Intercept", "y1", "y2")
X <- mls(dgp$x, 0:23, 12)

mmm_mod <- midas_mmm_plain(dgp$y, X, z, nnbeta, 
                          start_mmm = c(1.5, 1), 
                          start_x = c(2, 4), start_z=c(1, 0.5, 0)) 

coef(mmm_mod)

}
