% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_output_data.R
\name{get_output_data}
\alias{get_output_data}
\title{Get inverter output data}
\usage{
get_output_data(device_ip, model = "APSystems", ...)
}
\arguments{
\item{device_ip}{list or vector of devices IP address}

\item{model}{the inverter device model. Currently only "APSystems"
"Enphase-Envoy", "Enphase-Energy" and "Fronius" are supported.}

\item{...}{additional parameters passed to the inverter if needed.}
}
\value{
a dataframe with one row of device output power and energy per
  `device_id` / `inverter` combination.
}
\description{
Get inverter output data
}
\examples{
\dontrun{
get_output_data(c("192.168.0.12", "192.168.0.230"))
}

}
