% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex_tables.R
\name{toLatex.micomp}
\alias{toLatex.micomp}
\title{Convert \code{micomp} object to \code{LaTeX} table}
\usage{
\method{toLatex}{micomp}(object, ..., orientation = T,
  data_show = c("npcs-1", "mnvp-1", "parp-1", "nparp-1", "scoreplot"),
  data_labels = NULL, labels_cmp_show = T, labels_col_show = T,
  label_row_show = T, tag_comp = "Comp.", tag_data = "Data",
  tag_outputs = "Outputs", table_placement = "ht",
  latex_envs = c("center"), booktabs = F, booktabs_cmalign = "l",
  caption = NULL, caption_cmd = "\\\\caption", label = NULL,
  col_width = F, pvalf_f = pvalf.default, pvalf_params = list(),
  scoreplot_marks = c("mark=square*,mark options={color=red},mark size=0.8pt",
  "mark=diamond*,mark options={color=black},mark size=1pt",
  "mark=triangle*,mark options={color=green},mark size=1pt"),
  scoreplot_scale = 6,
  scoreplot_before = "\\\\raisebox{-.5\\\\height}{\\\\resizebox {1.2cm} {1.2cm} {",
  scoreplot_after = "}}")
}
\arguments{
\item{object}{A \code{\link{micomp}} object.}

\item{...}{Currently ignored.}

\item{orientation}{If TRUE, outputs are placed along columns, while data is
placed along rows. If FALSE, outputs are placed along rows, while data is
placed along columns.}

\item{data_show}{Vector of strings specifying what data to show. Available
options are:
\describe{
  \item{npcs-i}{Number of principal components required to explain i-th
        user-specified percentage of variance.}
  \item{mnvp-i}{MANOVA \emph{p}-values for the i-th user-specified percentage
        of variance to explain.}
  \item{parp-j}{Parametric test \emph{p}-values for the j-th principal
        component.}
  \item{nparp-j}{Non-parametric test \emph{p}-values for the j-th principal
        component.}
  \item{aparp-j}{Parametric test \emph{p}-values adjusted with weighted
        Bonferroni procedure for the j-th principal component.}
  \item{anparp-j}{Non-parametric test \emph{p}-values adjusted with weighted
        Bonferroni procedure for the j-th principal component.}
  \item{varexp-j}{Explained variance for the j-th principal component.}
  \item{scoreplot}{Output projection on the first two principal components.}
  \item{sep}{Place a separator (e.g. midrule) between data.}
}}

\item{data_labels}{Vector of strings specifying the labels of the data to
show. If NULL, default labels are used for all elements. If individual
elements are set to NA, default labels will be used for those elements.}

\item{labels_cmp_show}{Show the column containing the comparison labels?}

\item{labels_col_show}{Show the column containing the data labels
(\code{orientation == T}) or the output labels (\code{orientation == F})?}

\item{label_row_show}{Show the \code{tag_outputs} tag? If TRUE, the row
identifier part will have two levels, the \code{tag_outputs} label and output
names (\code{orientation == T}), or the \code{tag_data} and data labels
(\code{orientation == F}). If FALSE only the output names or data labels are
shown.}

\item{tag_comp}{Tag identifying comparison labels.}

\item{tag_data}{Tag identifying data labels.}

\item{tag_outputs}{Tag identifying outputs.}

\item{table_placement}{\code{LaTeX} table placement.}

\item{latex_envs}{Wrap table in the specified \code{LaTeX}
environments.}

\item{booktabs}{Use \code{booktabs} table beautifier package?}

\item{booktabs_cmalign}{How to align \code{cmidule} when using the
\code{booktabs} package.}

\item{caption}{Table caption.}

\item{caption_cmd}{Command used for table caption.}

\item{label}{Table label for cross-referencing.}

\item{col_width}{Resize table to page column width?}

\item{pvalf_f}{\emph{P}-value formatter function, which receives a numeric
value between 0 and 1 and returns a string containing the formatted value.
Default is \code{\link{pvalf.default}} (requires \code{ulem} \code{LaTeX}
package).}

\item{pvalf_params}{Parameters for \code{pvalf_f} function. Default is empty
list.}

\item{scoreplot_marks}{Vector of strings specifying how \code{TikZ} should
draw points belonging to each group in the score plot.}

\item{scoreplot_scale}{\code{TikZ} scale for each score plot figure.}

\item{scoreplot_before}{\code{LaTeX} code to paste before each \code{TikZ}
score plot figure.}

\item{scoreplot_after}{\code{LaTeX} code to paste after each \code{TikZ}
score plot figure.}
}
\value{
A character vector where each element holds one line of the
corresponding \code{LaTeX} table.
}
\description{
This method converts \code{\link{micomp}} objects to character vectors
representing \code{LaTeX} tables.
}
\details{
This method is inspired by the functionality provided by the \code{xtable}
and \code{print.xtable} functions (from the
\href{https://cran.r-project.org/package=xtable}{xtable}
package), but follows the standard behavior of the
\code{\link[utils]{toLatex}} generic.
}
\examples{

# Create a micomp object, use provided dataset, three first outputs, plus
# a fourth concatenated output
mic <- micomp(4, 0.8,
              list(list(name = "NLOKvsJEXOK", grpout = pphpc_ok),
                   list(name = "NLOKvsJEXNOSHUFF", grpout = pphpc_noshuff),
                   list(name = "NLOKvsJEXDIFF", grpout = pphpc_diff)),
              concat = TRUE)

# Print latex table source to screen
toLatex(mic)

}
