% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rubin2wt_one.R
\name{rubin2wt.one}
\alias{rubin2wt.one}
\title{2nd Rubin's rule Within-Variance Component (a given peptide)}
\usage{
rubin2wt.one(peptide, data, funcvar, metacond)
}
\arguments{
\item{peptide}{peptide for which the variance-covariance matrix should be derived.}

\item{data}{dataset}

\item{funcvar}{function that should be used to compute the variance}

\item{metacond}{a factor to specify the groups}
}
\value{
A variance-covariance matrix.
}
\description{
Computes the within-variance component in the 2nd Rubin's rule for a given peptide.
}
\examples{
library(mi4p)
data(datasim)
datasim_imp <- multi.impute(data = datasim[,-1], conditions = 
attr(datasim,"metadata")$Condition, method = "MLE")
rubin2wt.one(1,datasim_imp,funcvar=within_variance_comp_emmeans,
attr(datasim,"metadata")$Condition)
}
\references{
M. Chion, Ch. Carapito and F. Bertrand (2021). \emph{Accounting for multiple imputation-induced variability for differential analysis in mass spectrometry-based label-free quantitative proteomics}. arxiv:2108.07086. \url{https://arxiv.org/abs/2108.07086}.
}
