% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mhde.R
\name{mhde.test}
\alias{mhde.test}
\title{Minimum Hellinger Distance Test for Normality}
\usage{
mhde.test(DataVec, NGauss = 100, MaxIter = 25, InitLocation, InitScale,
  EpsLoc = 1e-04, EpsSca = 1e-04, Silent = FALSE, Small = FALSE)
}
\arguments{
\item{DataVec}{The data are supplied by the user in a numeric vector.  The length of the vector determines the number of data values.}

\item{NGauss}{The number of subintervals for the Gauss-Legendre integration techniques is controlled by \code{NGauss}.  A default value of 100 is used.  A minimum of 25 is enforced.}

\item{MaxIter}{The maximum number of iterations that can occur in evaluating the minimum Hellinger distance is controlled by \code{MaxIter}.  A default of 25 is used.  A minimum of 1 is enforced.}

\item{InitLocation}{An optional initial location estimate can be defined using \code{InitLocation}.  The data median is the default value.}

\item{InitScale}{An optional initial scale estimate can be defined using \code{InitScale}. The data median absolute deviation is the default value.}

\item{EpsLoc}{The epsilon (in data units) below which the iterative minimization approach declares convergence in the location estimate is controlled by \code{EpsLoc}.  \code{EpsLoc} should be set to give approximately 5 digits of accuracy in the location estimate. A default value of 0.0001 is used.}

\item{EpsSca}{The epsilon (in data units) below which the iterative minimization approach declares convergence in the SCALE estimate is controlled by \code{EpsSca}.  \code{EpsSca} should be set to give approximately 5 digits of accuracy in the scale estimate. A default value of 0.0001 is used.}

\item{Silent}{A value of FALSE for \code{Silent} writes several results to the R console.  Use \code{Silent}=TRUE to eliminate the output.}

\item{Small}{A value of FALSE for \code{Small} returns a list of 11 objects.  Use \code{Small}=TRUE to return a shorter list containing only the Hellinger distance and the p-value.}
}
\value{
Values returned in a list include the following items:
\itemize{
    \item {Minimized Hellinger distance}
    \item {p-value for the minimized distance}
    \item {Initial location used in the iterative solution}
    \item {Initial scale used in the iterative solution}
    \item {Final location estimate}
    \item {Final scale estimate}
    \item {Sample size}
    \item {Kernel density bandwidth parameter}
    \item {Vector of x values used in the integration for the Hellinger distance}
    \item {Vector of nonparametric density values at the x values used in the integration}
    \item {Vector of normal density values for the estimated location and scale at the x values used in integration}
}
}
\description{
This function fits a normal distribution to a data set using a mimimum Hellinger distance approach and
  then performs a test of hypothesis that the data are from a normal distribution.
}
\details{
Let \emph{f(x)} and \emph{g(x)} be absolutely continuous probability density functions.  The square of the
  Hellinger distance can be written as \eqn{H^2 = 1 - \int\sqrt{f(x)g(x)}dx}.  For this package, \emph{f(x)}
  denotes the family of normal densities and \emph{g} is a data-based density obtained by using the Ephanechnikov
  kernel. The kernel has the form \eqn{w(z)=0.75(1-z^2 )} for \samp{-1<z<1} and 0 elsewhere.  Let the
  \emph{n} sample data be denoted by \eqn{x_1}{X1}, ..., \eqn{x_n}{Xn}.  The data-based kernel density at any
  point \emph{y} is calculated from \deqn{g_n(y) = \frac{1}{n s_n c_n }\sum\limits_{i=1}^n w(\frac{y-x_i}{s_n c_n})}

  A Newton-Rhapson method with analytical derivatives is to determine the minimum Hellinger distance.
  Numerical integration is done using a 6-point composite Gauss-Legendre technique.
}
\examples{
## example with a normal data set
mhde.test(rnorm(20,0.0,1.0),Small=TRUE)

## example with a uniform data set including example plot
MyList <- mhde.test(runif(25,min=2,max=4))
mhde.plot(MyList)
}
\author{
Paul W. Eslinger and Heather M. Orr
}
\references{
Epanechnikov, VA. 1969. "Non-Parametric Estimation of a Multivariate Probability Density."
  Theory of Probability and its Applications 14(1):153-156. doi \url{http://dx.doi.org/10.1137/1114019}

  Hellinger, E. 1909. "Neue Begrundung Der Theorie Quadratischer Formen Von Unendlichvielen
  Veranderlichen." Journal fur die reine und angewandte Mathematik 136:210-271.
  doi \url{http://dx.doi.org/10.1515/crll.1909.136.210}
}

