% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{mgc.sims.spiral}
\alias{mgc.sims.spiral}
\title{Spiral Simulation}
\usage{
mgc.sims.spiral(n, d, eps = 0.4, a = 0, b = 5)
}
\arguments{
\item{n}{the number of samples for the simulation.}

\item{d}{the number of dimensions for the simulation setting.}

\item{eps}{the noise level for the simulation. Defaults to \code{0.5}.}

\item{a}{the lower limit for the data matrix. Defaults \code{-1}.}

\item{b}{the upper limit for the data matrix. Defaults to \code{1}.}
}
\value{
a list containing the following:
\item{\code{X}}{\code{[n, d]} the data matrix with \code{n} samples in \code{d} dimensions.}
\item{\code{Y}}{\code{[n]} the response array.}
}
\description{
A function for Generating a spiral simulation.
}
\examples{
library(mgc)
result  <- mgc.sims.wshape(n=100, d=10)  # simulate 100 samples in 10 dimensions
X <- result$X; Y <- result$Y
}
\author{
Eric Bridgeford
}
