% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGCLocalCorr.R
\name{mgc.localcorr}
\alias{mgc.localcorr}
\title{MGC Local Correlations}
\usage{
mgc.localcorr(X, Y, option = "mgc")
}
\arguments{
\item{X}{is interpreted as:
\itemize{
   \item{a \code{[n x n]} distance matrix}{X is a square matrix with zeros on diagonal for \code{n} samples.}
   \item{a \code{[n x d]} data matrix}{X is a data matrix with \code{n} samples in \code{d} dimensions.}
 }}

\item{Y}{is interpreted as:
\describe{
   \item{a \code{[n x n]} distance matrix}{Y is a square matrix with zeros on diagonal for \code{n} samples.}
   \item{a \code{[n x d]} data matrix}{Y is a data matrix with \code{n} samples in \code{d} dimensions.}
}}

\item{option}{is a string that specifies which global correlation to build up-on. Defaults to \code{'mgc'}.
\describe{
   \item{'mgc'}{use the MGC global correlation.}
   \item{'dcor'}{use the dcor global correlation.}
   \item{'mantel'}{use the mantel global correlation.}
   \item{'rank'}{use the rank global correlation.}
}}
}
\value{
A list contains the following:
\item{\code{corr}}{consists of all local correlations within [-1,1] by double matrix index}
\item{\code{varX}}{contains all local variances for X.}
\item{\code{varY}}{contains all local variances for X.}
}
\description{
Compute all local correlation coefficients in O(n^2 log n)
}
\examples{
library(mgc)

n=200; d=2
data <- mgc.sims.linear(n, d)
lcor <- mgc.localcorr(data$X, data$Y)

}
\author{
C. Shen
}
