% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mfp.R
\name{find_best_fp_cycle}
\alias{find_best_fp_cycle}
\title{Helper to run cycles of the mfp algorithm}
\usage{
find_best_fp_cycle(
  x,
  y,
  powers_current,
  df,
  weights,
  offset,
  family,
  criterion,
  select,
  alpha,
  keep,
  powers,
  method,
  strata,
  verbose,
  ftest,
  control,
  rownames,
  nocenter,
  acdx
)
}
\arguments{
\item{x}{an input matrix of dimensions nobs x nvars. Does not contain
intercept, but columns are already expanded into dummy variables as
necessary. Data are assumed to be shifted and scaled.}

\item{y}{a vector for the response variable or a \code{Surv} object.}

\item{powers_current}{a list of length equal to the number of variables,
indicating the fp powers to be used in the current step for all variables
(except \code{xi}).}

\item{df}{a numeric vector of length nvars of degrees of freedom.}

\item{weights}{a vector of observation weights of length nobs.}

\item{offset}{a vector of length nobs of offsets.}

\item{family}{a character string representing a family object.}

\item{criterion}{a character string defining the criterion used to select
variables and FP models of different degrees.}

\item{select}{a numeric vector of length nvars indicating significance levels
for backward elimination.}

\item{alpha}{a numeric vector of length nvars indicating significance levels
for tests between FP models of different degrees.}

\item{keep}{a character vector with names of variables to be kept
in the model.}

\item{powers}{a named list of numeric values that sets the permitted FP
powers for each covariate.}

\item{method}{a character string specifying the method for tie handling in
Cox regression model.}

\item{strata}{a factor of all possible combinations of stratification
variables. Returned from \code{\link[survival:strata]{survival::strata()}}.}

\item{verbose}{a logical; run in verbose mode.}

\item{ftest}{a logical indicating the use of the F-test for Gaussian models.}

\item{control}{a list with parameters for model fit. See \code{\link[survival:coxph]{survival::coxph()}}
or \code{\link[stats:glm]{stats::glm()}} for details.}

\item{rownames}{passed to \code{\link[survival:agreg.fit]{survival::coxph.fit()}}.}

\item{nocenter}{a numeric vector with a list of values for fitting Cox
models. See \code{\link[survival:coxph]{survival::coxph()}} for details.}

\item{acdx}{a logical vector of length nvars indicating which continuous
variables should undergo the approximate cumulative distribution (ACD)
transformation.}
}
\value{
current FP powers
}
\description{
This function estimates the best FP functions for all predictors in the
current cycle. To be used in \code{\link[=fit_mfp]{fit_mfp()}}.
}
\details{
A cycle is defined as a complete pass through all the predictors in the input
matrix \code{x}, while a step is defined as the assessment of a single predictor.
This algorithm is described in Sauerbrei et al. (2006) and given in detail
in Royston and Sauerbrei (2008), in particular chapter 6.

Briefly, a cycle works as follows: it takes as input the data matrix along with
a set of current best fp powers for each variable. In each step, the fp
powers of a single covariate are assessed, while adjusting for other
covariates. Adjustment variables are transformed using their current
fp powers (this is done in \code{\link[=transform_data_step]{transform_data_step()}}) and the fp powers
of the variable of interest are tested using the closed test procedure
(conducted in \code{\link[=find_best_fp_step]{find_best_fp_step()}}).
Some of the adjustment variables may have their fp power set to \code{NA},
which means they were not selected from the working model and are not used
in that step. The results from all steps are returned, completing a cycle.

Note that in each cycle every variable is evaluated.This includes variables
that may have been eliminated in previous cycles. They will re-enter each
new cycle for potential inclusion in the working model or to be re-evaluated
for elimination.

The current adjustment set is always given through the current fp powers,
which are updated in each step (denoted as \code{powers_current}).
}
\references{
Royston, P. and Sauerbrei, W., 2008. \emph{Multivariable Model - Building:
A Pragmatic Approach to Regression Anaylsis based on Fractional Polynomials
for Modelling Continuous Variables. John Wiley & Sons.}\cr
Sauerbrei, W., Meier-Hirmer, C., Benner, A. and Royston, P., 2006.
\emph{Multivariable regression model building by using fractional
polynomials: Description of SAS, STATA and R programs.
Comput Stat Data Anal, 50(12): 3464-85.}
Sauerbrei, W. and Royston, P., 1999. \emph{Building multivariable prognostic
and diagnostic models: transformation of the predictors by using fractional
polynomials. J Roy Stat Soc a Sta, 162:71-94.}
}
