% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp.R
\name{.fit.gpd.rob}
\alias{.fit.gpd.rob}
\title{Robust threshold selection of Dupuis}
\usage{
.fit.gpd.rob(dat, thresh, k = 4, tol = 1e-05, show = FALSE)
}
\arguments{
\item{dat}{a numeric vector of data}

\item{thresh}{threshold parameter}

\item{k}{bound on the influence function; the constant \code{k} is a robustness parameter
(higher bounds are more efficient, low bounds are more robust). Default to 4.}

\item{tol}{numerical tolerance for OBRE weights iterations.}

\item{show}{logical: should diagnostics and estimates be printed. Default to \code{FALSE}.}
}
\value{
a list with the same components as \code{\link{fit.gpd}},
in addition to
\itemize{
\item{\code{estimate}:}{optimal bias-robust estimates of the \code{scale} and \code{shape} parameters.}
\item{\code{weights}:}{vector of OBRE weights.}
}
}
\description{
The optimal bias-robust estimator (OBRE) for the generalized Pareto.
This function returns robust estimates and the associated weights.
}
\examples{
dat <- rexp(100)
.fit.gpd.rob(dat, 0.1)
}
\references{
Dupuis, D.J. (1998). Exceedances over High Thresholds: A Guide to Threshold Selection,
\emph{Extremes}, \bold{1}(3), 251--261.
}
\seealso{
\code{\link{fit.gpd}}
}
\keyword{internal}
