% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/next-train.R
\name{next_train}
\alias{next_train}
\title{Next Trains}
\format{
A tibble 1 row per arrival with 9 variables:
\describe{
\item{Car}{Number of cars on a train, usually 6 or 8, but might also \code{NA}.}
\item{Destination}{Abbreviated version of the final destination for a
train. This is similar to what is displayed on the signs at stations.}
\item{DestinationCode}{}Destination station code. Can be \code{NA}. Use this
value in other rail-related APIs to retrieve data about a station.
\item{DestinationName}{When \code{DestinationCode} is populated, this is the
full name of the destination station, as shown on the WMATA website.}
\item{Group}{Denotes the track this train is on, but does not necessarily
equate to Track 1 or Track 2. With the exception of terminal stations,
predictions at the same station with different Group values refer to trains
on different tracks.}
\item{Line}{Two-letter abbreviation for the line (e.g.: RD, BL, YL, OR, GR,
or SV). May also be \code{NA} for trains with no passengers.}
\item{LocationCode}{Station code for where the train is arriving. Useful
when passing in All as the \code{StationCodes} parameter. Use this value in
other rail-related APIs to retrieve data about a station.}
\item{LocationName}{Full name of the station where the train is arriving.
Useful when passing in "All" as the \code{StationCodes} parameter.}
\item{Min}{Minutes until arrival. Can be a numeric value, 0 (arriving),
-1 (boarding), or \code{NA}.}
}
}
\usage{
next_train(StationCodes = NULL, api_key = wmata_key())
}
\arguments{
\item{StationCodes}{Character vector of station codes. For all predictions,
use \code{NULL} (default) or "All".}

\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
Data frame of train arrivals.
}
\description{
Returns next train arrival information for one or more stations. Will return
an empty set of results when no predictions are available. Use "All" for the
\code{StationCodes} parameter to return predictions for all stations.
}
\details{
For terminal stations (e.g.: Greenbelt, Shady Grove, etc.), predictions may
be displayed twice.

Some stations have two platforms (e.g.: Gallery Place, Fort Totten, L'Enfant
Plaza, and Metro Center). To retrieve complete predictions for these
stations, be sure to pass in both StationCodes.

For trains with no passengers, the \code{DestinationName} will be "No Passenger".
}
\examples{
\dontrun{
next_train(StationCodes = c("A02", "B02"))
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/547636a6f9182302184cda78/operations/547636a6f918230da855363f}

Other Real-Time Predictions: 
\code{\link{next_bus}()}
}
\concept{Real-Time Predictions}
