% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidents-bus.R
\name{bus_incidents}
\alias{bus_incidents}
\title{Bus Incidents}
\format{
A data frame with 1 row per incident and 5 variables:
\describe{
\item{IncidentID}{Unique identifier for an incident.}
\item{IncidentType}{Free-text description of the incident type. Usually
\code{Delay} or \code{Alert} but is subject to change at any time.}
\item{RoutesAffected}{Character string of routes affected. Routes listed
are usually identical to base route names (i.e.: not 10Av1 or 10Av2, but
10A), but may differ from what our bus methods return.}
\item{Description}{Free-text description of the delay or incident.}
\item{DateUpdated}{Date and time (UTC) of last update.}
}
}
\usage{
bus_incidents(Route = NULL, api_key = wmata_key())
}
\arguments{
\item{Route}{Base bus route; variations are not recognized (i.e.: C2 instead
of C2v1, C2v2, etc.).}

\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
Data frame of bus incidents and delays.
}
\description{
Returns a set of reported bus incidents/delays for a given Route. Omit the
Route to return all reported items.
}
\details{
Note that the Route parameter accepts only base route names and no
variations, i.e.: use 10A instead of 10Av1 and 10Av2.
}
\examples{
\dontrun{
bus_incidents()
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/54763641281d83086473f232/operations/54763641281d830c946a3d75}

Other Incident APIs: 
\code{\link{elevator_incidents}()},
\code{\link{rail_incidents}()}
}
\concept{Incident APIs}
