% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_metrix.R
\name{comp_metrix}
\alias{comp_metrix}
\title{Complete metrix analysis}
\usage{
comp_metrix(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating indicating if progress messages should be given.}
}
\value{
This function returns a list with the following components:
\item{Bioind_n}{The numerical values of the biotic indexes.}
\item{Bioind_c}{The water quality class asign to each sample site according to the numerical value of the biotic index.}
\item{d_diver}{A data.frame with all the calculated density measures.}
\item{Icbrio_n}{The numerical ICBrio index.}
\item{Icbrio_c}{The ICBrio water quality class.}
\item{Indrel}{A data.frame with all the calculated tolerance measures.}
\item{Perdiver}{A data.frame with all the calculated composition measures.}
\item{Pred}{A data.frame with all the calculated trophic measures.}
\item{Richdiver}{A data.frame with all the calculated richness measures.}
}
\description{
This function performs all the calculations availables in metrix package.
}
\examples{
#Example data is a properly formatted table with richness measures of two sites
example_data

#Run comp_metrix with that example_data
complete<-comp_metrix(example_data)

#Check results
complete$Bioind_n
complete$Bioind_c
complete$d_diver
complete$Icb_n
complete$Icb_c
complete$Indrel
complete$Perdiver
complete$Pred
complete$Richdiver
}
\seealso{
\link[metrix]{read_data}, \link[metrix]{biotic_ind}, \link[metrix]{densi_diver}, \link[metrix]{icbrio_ind}, \link[metrix]{indrel_diver}, \link[metrix]{per_diver}, \link[metrix]{pred_ind}, \link[metrix]{rich_diver}
}
\author{
Juan Manuel Cabrera and Julieta Capeleti.
}
